//: Playground - noun: a place where people can play

import Cocoa

class RDSViewClass : NSView
{
    override init(frame: CGRect) 
    {
        super.init(frame:frame)  
        srand48(2);// 毎回同じ乱数を発生させたいので定数を与える
    }

    required init(coder aDecoder: NSCoder) 
    {
        fatalError("init(coder:) has not been implemented")
    }

    override func draw(_ r: CGRect)
    {
        // 中心点を適当に決める
        let theCenterPoint : NSPoint
        
        theCenterPoint = NSMakePoint(self.frame.width / 2, self.frame.height / 2)

        // theCenterPoint = self.randomPoint()
        // NSColor.red.set()
        // self.dot(point:theCenterPoint)
        
        NSColor.black.set()

        // ループの外で変換用の行列を準備する
        let theAffine = self.affineTransform(centerPoint: theCenterPoint)
                
        for _ in 1...1000
        {
            // ランダムな位置に点を穿つ
            let thePoint = self.randomPoint()
            self.dot(point:thePoint)
            
            // thePointを変換用行列でずらして穿つ
            self.dot(point:theAffine.transform(thePoint))
        }
    }
    
    // アフィン変換用行列の作成
    func affineTransform(centerPoint: NSPoint) -> NSAffineTransform
    {
        let theAffine = NSAffineTransform()
        
        theAffine.translateX(by:centerPoint.x, yBy:centerPoint.y)
        
        // centerPointを中心に回転
        theAffine.rotate(byDegrees:4)                                    // <-- ここが回転角度
        // centerPointを中心に拡大
        theAffine.scale(by:1.0)                                          // <-- ここが拡大率
        
        theAffine.translateX(by:-centerPoint.x, yBy:-centerPoint.y)
        
        return theAffine
    }

    // 引数pointで示される位置に点描画する
    func dot(point: NSPoint)
    {
        let theDot = NSBezierPath(ovalIn: NSMakeRect(point.x, point.y, 1, 1))
        theDot.stroke()
    }
    
    // ランダムな点を作る
    func randomPoint() -> NSPoint
    {
        return NSMakePoint(
            CGFloat(Int(drand48()*1000) % Int(self.frame.width)),
            CGFloat(Int(drand48()*1000) % Int(self.frame.height)))
    }    
}

var theRDSObject = RDSViewClass(frame:CGRect(x: 0, y: 0, width:600, height:400))




