//
//  TDLInspectorViewController.swift
//  ToDoList
//
//  Created by narita on 2017/09/12.
//  Copyright © 2017年 narita. All rights reserved.
//

import Cocoa

class TDLInspectorViewController: MINTLViewController
{

    // MARK: - class methods
    
    // MARK: - init methods
    
    // MARK: - dealloc
    
    // MARK: - NSCopying, hash, isEqual:
    
    // MARK: - NSCoding methods
    
    // MARK: - restorableState methods
    
    // MARK: - life cycle methods
    
    override func viewDidLoad()
    {
        super.viewDidLoad()
        
        // NSArrayControllerのarrangedArrayが変更された場合は、サーチ用の
        // データを再構築させるために、無効にする
        self.objectsObservation = observe(\.arrayController?.selection)
        {_,_ in
            
            if let theSelectedObject: NSObject = self.arrayController?.selection as? NSObject
            {
                if let theDate: Date = theSelectedObject.value(forKeyPath:"createdDate") as? Date
                {
                    self.datePicker!.dateValue = theDate
                }
                
                if let theMemo: String = theSelectedObject.value(forKeyPath:"memo") as? String
                {
                    self.memoField!.string = theMemo
                }
            }
        }
    }
        
    // MARK: - action methods

    
    // MARK: - event handling methods

    // MARK: - drawing methods
    
    // MARK: - delegate/datasource methods
    
    // MARK: - accessor methods (in pairs)

    @objc class func keyPathsForValuesAffectingArrayController() -> Set<String>
    {
        return [ "windowController", "windowController.arrayController"]
    }

    @objc var arrayController: NSArrayController?
    {
        return self.value(forKeyPath: "windowController.arrayController") as? NSArrayController
    }

    @objc class func keyPathsForValuesAffectingManagedObjectContext() -> Set<String>
    {
        return [ "document", "document.managedObjectContext"]
    }

    @objc var managedObjectContext: NSManagedObjectContext?
    {
        return self.value(forKeyPath: "document.managedObjectContext") as? NSManagedObjectContext
    }
    
    @IBOutlet var memoField: NSTextView?

    @IBOutlet var datePicker: NSDatePicker?

    var objectsObservation: NSKeyValueObservation? = nil   // KVOでobjectControllerの配列を監視

    // MARK: - Utility methods
    
}
