//
//  TEDefaultKeys.swift
//  TextEditDoc
//
//  Created by narita on 2018/12/29.
//  Copyright © 2018 narita. All rights reserved.
//

import Foundation

struct TEDefaultKeys
{
    // Note that not all keys in this file are exposed in the UI. Some of them are not used at all, but are kept for reference.
    static let RichText = "RichText"
    static let ShowPageBreaks = "ShowPageBreaks"
    static let AddExtensionToNewPlainTextFiles = "AddExtensionToNewPlainTextFiles"
    static let WindowWidth = "WidthInChars"
    static let WindowHeight = "HeightInChars"
    static let PlainTextEncodingForRead = "PlainTextEncoding"
    static let PlainTextEncodingForWrite = "PlainTextEncodingForWrite"
    static let IgnoreRichText = "IgnoreRichText"
    static let IgnoreHTML = "IgnoreHTML"
    static let TabWidth = "TabWidth"
    static let ForegroundLayoutToIndex = "ForegroundLayoutToIndex"
    static let OpenPanelFollowsMainWindow = "OpenPanelFollowsMainWindow"
    static let CheckSpellingAsYouType = "CheckSpellingWhileTyping"
    static let CheckGrammarWithSpelling = "CheckGrammarWithSpelling"
    static let CorrectSpellingAutomatically = "CorrectSpellingAutomatically"
    static let ShowRuler = "ShowRuler"
    static let SmartCopyPaste = "SmartCopyPaste"
    static let SmartQuotes = "SmartQuotes"
    static let SmartDashes = "SmartDashes"
    static let SmartLinks = "SmartLinks"
    static let DataDetectors = "DataDetectors"
    static let TextReplacement = "TextReplacement"
    static let SubstitutionsEnabledInRichTextOnly = "SubstitutionsEnabledInRichTextOnly"
    static let UseXHTMLDocType = "UseXHTMLDocType"
    static let UseTransitionalDocType = "UseTransitionalDocType"
    static let UseEmbeddedCSS = "UseEmbeddedCSS"
    static let UseInlineCSS = "UseInlineCSS"
    static let HTMLEncoding = "HTMLEncoding"
    static let PreserveWhitespace = "PreserveWhitespace"
    static let AutosavingDelay = "AutosavingDelay"
    static let NumberPagesWhenPrinting = "NumberPagesWhenPrinting"
    static let WrapToFitWhenPrinting = "WrapToFitWhenPrinting"
    static let UseScreenFonts = "UseScreenFonts"
    
    // Use different convention for the key values here, to be consistent with the keys in Document
    static let AuthorProperty = "author"
    static let CompanyProperty = "company"
    static let CopyrightProperty = "copyright"    
}


