//
//  TEPreferencesWindowController.swift
//  TextEditDoc
//
//  Created by narita on 2018/12/29.
//  Copyright © 2018 narita. All rights reserved.
//

import Cocoa


@objc public enum HTMLStylingMode :  UInt
{
    case useEmbeddedCSS  = 0
    case useInlineCSS    = 1
    case useNoCSS        = 2
}

@objc public enum HTMLDocumentTypeOptions : UInt
{
    case none                    = 0
    case useTransitional         = 1
    case useXHTML                = 2
    case useTransitionalAndXHTML = 3
}


class TEPreferencesWindowController: MINTLPreferencesWindowController
{
    // MARK: - class methods

    // MARK: - init methods
    
    // MARK: - dealloc
    
    // MARK: - NSCopying, hash, isEqual:
    
    // MARK: - NSCoding methods
    
    // MARK: - restorableState methods
    
    // MARK: - life cycle methods
    
    // MARK: - action methods
    
    @IBAction func revertToDefault(_ sender : Any?)
    {
        let theUD = UserDefaults.standard

        self.willChangeValue(forKey: "HTMLDocumentType")
        theUD.removeObject(forKey: TEDefaultKeys.UseXHTMLDocType)
        theUD.removeObject(forKey: TEDefaultKeys.UseTransitionalDocType)
        self.didChangeValue(forKey: "HTMLDocumentType")

        self.willChangeValue(forKey: "HTMLStylingMode")
        theUD.removeObject(forKey: TEDefaultKeys.UseEmbeddedCSS)
        theUD.removeObject(forKey: TEDefaultKeys.UseInlineCSS)
        self.didChangeValue(forKey: "HTMLStylingMode")

        self.richTextFont = nil
        self.plainTextFont = nil
        
        NSUserDefaultsController.shared.revertToInitialValues(nil)
    }

    // MARK: - event handling methods
    
    // MARK: - drawing methods
    
    // MARK: - delegate/datasource methods
    
    // MARK: - accessor methods (in pairs)
    
    @objc dynamic var HTMLDocumentType: HTMLDocumentTypeOptions
    {
        set(newValue)
        {
            let theUD = UserDefaults.standard

            // bit演算子が使えて、objcな型をどう作れば良いかわからない
            
            theUD.set(  Bool(newValue == .useXHTML || newValue == .useTransitionalAndXHTML) ,
                      forKey: TEDefaultKeys.UseXHTMLDocType)

            theUD.set( Bool( newValue == .useTransitional || newValue == .useTransitionalAndXHTML),
                      forKey: TEDefaultKeys.UseTransitionalDocType)
        }
        
        get
        {
            let theUD = UserDefaults.standard
            var theType: HTMLDocumentTypeOptions = .none
            
            if theUD.bool(forKey: TEDefaultKeys.UseXHTMLDocType)
            {
                theType = HTMLDocumentTypeOptions(rawValue: theType.rawValue + HTMLDocumentTypeOptions.useXHTML.rawValue ) ?? .useXHTML
            }
            
            if theUD.bool(forKey: TEDefaultKeys.UseTransitionalDocType)
            {
                theType = HTMLDocumentTypeOptions(rawValue: theType.rawValue + HTMLDocumentTypeOptions.useTransitional.rawValue) ?? .useTransitional
            }
            
            return theType
        }
    }

    @objc dynamic var HTMLStylingMode: HTMLStylingMode
    {
        set(newValue)
        {
            var useEmbedded: Bool = false
            var useInline: Bool = false
            
            switch (newValue)
            {
                case .useEmbeddedCSS:
                    useEmbedded = true
                    break
                
                case .useInlineCSS:
                    useInline = true
                    break
                
                case .useNoCSS:
                    break
            }
            
            let theUD = UserDefaults.standard

            theUD.set(useEmbedded, forKey: TEDefaultKeys.UseEmbeddedCSS)
            theUD.set(useInline, forKey: TEDefaultKeys.UseInlineCSS)
        }
        
        get
        {
            let theUD = UserDefaults.standard

            if theUD.bool(forKey: TEDefaultKeys.UseEmbeddedCSS)
            {
                return .useEmbeddedCSS
            }
            else if theUD.bool(forKey: TEDefaultKeys.UseInlineCSS)
            {
                return .useInlineCSS
            }
            else
            {
                return .useNoCSS
            }
        }
    }

    @objc dynamic var richTextFont: NSFont?
    {
        set(newValue)
        {
            NSFont.setUser(newValue)
        }
        
        get
        {
            return NSFont.userFont(ofSize: 0.0)
        }
    }
    
    @objc dynamic var plainTextFont: NSFont?
    {
        set(newValue)
        {
            NSFont.setUserFixedPitch(newValue)
        }
        
        get
        {
            return NSFont.userFixedPitchFont(ofSize: 0.0)
        }
    }

    // MARK: - Utility methods
}
