//
//  ToDoItem+CoreDataClass.swift
//  ToDoList
//
//  Created by narita on 2017/09/20.
//  Copyright © 2017年 narita. All rights reserved.
//
//

import Foundation
import CoreData
import Cocoa

@objc(ToDoItem)
public class ToDoItem: NSManagedObject, NSPasteboardWriting
{
    // MARK: - class methods
    
    class public func newToDoItem(context: NSManagedObjectContext)-> ToDoItem?
    {
        let theObject = NSEntityDescription.insertNewObject(forEntityName:"ToDoItem", into:context) as? ToDoItem
        
        return theObject
    }
    
    // 固有のurlを持つToDoItemを返す
    class public func toDoItem(from url:URL, context: NSManagedObjectContext)-> ToDoItem?
    {
        let theObjectID = context.persistentStoreCoordinator?.managedObjectID(forURIRepresentation:url)

        return context.object(with: theObjectID!) as? ToDoItem
    }
    
    // ペーストデータのURLからToDoItemを探し出して返す
    class public func toDoItem(fromURL pasteboardItem:NSPasteboardItem, context: NSManagedObjectContext)-> ToDoItem?
    {
        if let theURLString = pasteboardItem.propertyList(forType: NSPasteboard.PasteboardType.init("com.mindto01s.ToDoList.ToDoItemURL"))
        {
            let theObjectID = context.persistentStoreCoordinator?.managedObjectID(
                forURIRepresentation: URL.init(string: theURLString as! String)!
            )
            
            return context.object(with: theObjectID!) as? ToDoItem
        }
        
        return nil
    }

    // ペーストボードのデータからコピーを作成
    class public func toDoItem(fromPlist pasteboardItem:NSPasteboardItem, context: NSManagedObjectContext)-> ToDoItem?
    {
        let theObject = ToDoItem.newToDoItem(context: context)
        
        if let plist = pasteboardItem.propertyList(forType: NSPasteboard.PasteboardType.init("com.mindto01s.ToDoList.ToDoItem"))
        {
            theObject!.setValueForPasteboardDictionary(plist as! [String : Any])
            
            return theObject!
        }
        
        return nil
    }
    
    // MARK: - init methods
    
    // MARK: - dealloc
    
    // MARK: - NSCopying, hash, isEqual:
    
    // MARK: - NSCoding methods
    
    // ペーストボードから読み込むPastebordType型
    class public func readableType() -> NSPasteboard.PasteboardType
    {
        return NSPasteboard.PasteboardType.init("TDLToDoItems")
    }

    // 辞書形式から値の代入は以下のメソッドを使う
    func setValueForPasteboardDictionary(_ dictionary:[String : Any])
    {
        self.setValuesForKeys(dictionary)
        
        self.sortOrder = -1 // ソート番号は不定
    }
    
    public static func readableTypes(for pasteboard: NSPasteboard) -> [NSPasteboard.PasteboardType]
    {
        return [
            NSPasteboard.PasteboardType.init("com.mindto01s.ToDoList.ToDoItem")
        ]
    }

    // MARK: - NSPasteboardWriting
    
    // ペーストボードへ書き込む型
    
    @objc public func writableTypes(for pasteboard: NSPasteboard) -> [NSPasteboard.PasteboardType]
    {
        return [
            NSPasteboard.PasteboardType.init("com.mindto01s.ToDoList.ToDoItem"),
            NSPasteboard.PasteboardType.init("com.mindto01s.ToDoList.ToDoItemURL")
        ]
    }
    
    @objc public func pasteboardPropertyList(forType type: NSPasteboard.PasteboardType) -> Any?
    {
        switch type
        {
            case NSPasteboard.PasteboardType.init("com.mindto01s.ToDoList.ToDoItem"):
                return self.dictionaryWithValues(
                    forKeys: Array(self.entity.attributesByName.keys))

            case NSPasteboard.PasteboardType.init("com.mindto01s.ToDoList.ToDoItemURL"):
                return self.objectID.uriRepresentation().absoluteString
            
            default:
                return nil
        }
    }

    // MARK: - restorableState methods

    // MARK: - life cycle methods
    
    override public func awakeFromInsert()
    {
        self.createdDate = NSDate.init(timeIntervalSinceNow:0)
        self.memo        = ""
        self.done        = false
        self.sortOrder   = 1
    }
    
    // MARK: - action methods

    // MARK: - event handling methods
    
    // MARK: - drawing methods
    
    // MARK: - delegate/datasource methods

    // MARK: - accessor methods (in pairs)

    // MARK: - Utility methods

}
