//
//  ToDoItem+CoreDataProperties.swift
//  ToDoList
//
//  Created by narita on 2017/09/20.
//  Copyright © 2017年 narita. All rights reserved.
//
//

import Foundation
import CoreData


extension ToDoItem
{
    @nonobjc public class func fetchRequest() -> NSFetchRequest<ToDoItem>
    {
        return NSFetchRequest<ToDoItem>(entityName: "ToDoItem")
    }

    @nonobjc public class func sortedToDoItemsFetchRequest() -> NSFetchRequest<ToDoItem>
    {
        let theFetchRequest: NSFetchRequest<ToDoItem> = ToDoItem.fetchRequest()
        theFetchRequest.sortDescriptors = [NSSortDescriptor(key: "sortOrder", ascending: true)]

        return theFetchRequest
    }

    @NSManaged public var createdDate: NSDate?
    @NSManaged public var done: NSNumber?
    @NSManaged public var memo: String?
    @NSManaged public var sortOrder: Int32
    
    public var  doneAndMemoString: String
    {
        var theResult = ""
        
        if self.done != nil
        {
            theResult = self.done! == 0 ? "◽︎" : "☑︎"
        }
        
        if self.memo != nil
        {
            theResult = theResult + " " + self.memo!
        }
        
        return theResult
    }
}
