//
//  GetMetadataForFile.swift
//  ToDoSpotlight
//
//  Created by narita on 2018/05/03.
//  Copyright © 2018年 narita. All rights reserved.
//

import Foundation
import CoreFoundation
import CoreServices
import CoreData

@_cdecl("GetMetadataForFile")
func GetMetadataForFile(    thisInterface:  UnsafeRawPointer,
                            attributes:     CFMutableDictionary,
                            contentTypeUTI: CFString,
                            pathToFile:     CFString) -> DarwinBoolean
{
    var theResult: DarwinBoolean = false

    autoreleasepool
    {
        let theContentTypeUTI: String = contentTypeUTI as String

        switch theContentTypeUTI
        {
            case "public.data":
                theResult = true
                
                let theTextContent: CFString = "swift GetMetadataForFile swift \(contentTypeUTI)" as CFString
                
                CFDictionaryAddValue(attributes,
                                     unsafeBitCast(kMDItemTextContent, to: UnsafeRawPointer.self),
                                     unsafeBitCast(theTextContent, to: UnsafeRawPointer.self))

            default:
                theResult = false
        }


    }


    return theResult
}
