//
//  MINTLEncodingPanelController.swift
//  ControlSikenjo
//
//  Created by narita on 2018/12/31.
//  Copyright © 2018 narita. All rights reserved.
//

import Cocoa

class MINTLEncodingPanelController: MINTLWindowController, NSWindowRestoration
{
    // MARK: - class methods
    
    static var singletonSharedInstance : MINTLEncodingPanelController? = nil
    
    class func sharedInstance() -> MINTLEncodingPanelController?
    {
        if( singletonSharedInstance == nil )
        {
            singletonSharedInstance
                = NSStoryboard(name:"MINTLEncodingPanelController")
                    .instantiateInitialController() as! MINTLEncodingPanelController?
        }
        
        return singletonSharedInstance
    }

    // MARK: - init methods
    
    // MARK: - dealloc
    
    // MARK: - NSCopying, hash, isEqual:
    
    // MARK: - NSCoding methods
    
    // MARK: - restorableState methods
    
    static func restoreWindow(withIdentifier identifier: NSUserInterfaceItemIdentifier,
                              state: NSCoder,
                              completionHandler: @escaping (NSWindow?, Error?) -> Void)
    {
        var theWindow: NSWindow? = nil
        
        if( identifier.rawValue == "EncodingPanel" )
        {
            theWindow = MINTLEncodingPanelController.sharedInstance()?.window
        }
        
        completionHandler(theWindow, nil);
    }
    
    // MARK: - life cycle methods
    
    override func windowDidLoad()
    {
        super.windowDidLoad()
        
        self.window!.restorationClass = MINTLEncodingPanelController.self
    }

    // MARK: - action methods
    
    @IBAction func showEncodingPanel(_ sender : Any?)
    {
        self.showWindow(sender)
    }
    
    @objc func canShowEncodingPanel(_ sender : Any?) -> Bool
    {
        return self.window?.isMainWindow == false
    }

    // MARK: - event handling methods
    
    // MARK: - drawing methods
    
    // MARK: - delegate/datasource methods
    
    // MARK: - accessor methods (in pairs)
    
    // MARK: - Utility methods


}
