//
//  MINTLPersistentDocument.swift
//  TravelAdvisor
//
//  Created by narita on 2017/09/02.
//  Copyright © 2017年 narita. All rights reserved.
//

import Cocoa

class MINTLPersistentDocument: NSPersistentDocument
{
    // MARK: - class methods
    
    // MARK: - init methods
    
    // MARK: - dealloc
    
    // MARK: - NSCopying, hash, isEqual:
    
    // MARK: - NSCoding methods
    
    // MARK: - restorableState methods
    
    override func restoreWindow(withIdentifier identifier: NSUserInterfaceItemIdentifier,
                                state: NSCoder,
                                completionHandler: @escaping (NSWindow?, Error?) -> Void)
    {
        let theDocumentWindowIdentifer: NSString = "\(self.windowControllerName):" as NSString
        
        if identifier.rawValue.hasPrefix(theDocumentWindowIdentifer as String)
        {
            let theLength = theDocumentWindowIdentifer.length
            let theIdentifier = identifier as NSString
            
            let theIndexString: NSString = theIdentifier.substring(from: theLength) as NSString
            let theIndex   = theIndexString.integerValue
            
            var theWindowController: NSWindowController? = nil
            
            if self.windowControllers.count > theIndex
            {
                theWindowController = self.windowControllers[theIndex]
            }
            else
            {
                theWindowController = self.makeNewWindowController()
            }
            
            completionHandler(theWindowController!.window, nil)
        }
        else
        {
            super.restoreWindow(withIdentifier: identifier,
                                state: state,
                                completionHandler: completionHandler)
        }
    }
    
    
    // MARK: - life cycle methods
    
    // MARK: - action methods
    
    @IBAction func makeNewWindow(_ sender: NSObject!)
    {
        let theWindowController = self.makeNewWindowController()
        
        theWindowController?.showWindow(sender)
    }
    
    // MARK: - event handling methods
    
    // MARK: - drawing methods
    
    // MARK: - delegate/datasource methods
    
    override func addWindowController(_ windowController: NSWindowController)
    {
        super.addWindowController(windowController)
        
        self.windowControllers.forEach()
        {
                let theWindowController: MINTLWindowController = $0 as! MINTLWindowController
                
                theWindowController.synchronizeWindowTitleWithDocumentName()
                theWindowController.synchronizeUserInterfaceIdentifier()
        }
    }
    
    override func removeWindowController(_ windowController: NSWindowController)
    {
        super.removeWindowController(windowController)
        
        self.windowControllers.forEach()
        {
                let theWindowController: MINTLWindowController = $0 as! MINTLWindowController
                
                theWindowController.synchronizeWindowTitleWithDocumentName()
                theWindowController.synchronizeUserInterfaceIdentifier()
        }
    }
    
    // MARK: - accessor methods (in pairs)
    
    open var windowControllerClass: NSWindowController.Type
    {
        // サブクラスで書き換える
        return MINTLWindowController.self
    }
    
    open var windowControllerName: String
    {
        return "\(self.windowControllerClass.classForCoder())"
    }
    
    // MARK: - Utility methods
    
    func makeNewWindowController() -> MINTLWindowController?
    {
        let storyboard = NSStoryboard(name: self.windowControllerName, bundle: nil)
        
        let theWindowController = storyboard.instantiateInitialController() as! MINTLWindowController
        
        self.addWindowController(theWindowController)
        
        if let theContentsViewController = theWindowController.contentViewController
        {
            theContentsViewController.representedObject = self
        }
        
        return theWindowController
    }
    
    override func makeWindowControllers()
    {
        self.makeNewWindow(self)
    }
    
    override func validateUserInterfaceItem(_ item: NSValidatedUserInterfaceItem) -> Bool
    {
        return respondsAndPerformValidatedUserInterface(item)
        {
            super.validateUserInterfaceItem($0)
        }
    }
}
