//
//  MINTLPreferencesWindowController.swift
//  MenuTester
//
//  Created by narita on 2017/08/03.
//  Copyright © 2017年 narita. All rights reserved.
//

import Cocoa

class MINTLPreferencesWindowController: MINTLWindowController, NSWindowRestoration
{
    // MARK: - class methods
    
    static var singletonSharedInstance : MINTLPreferencesWindowController? = nil
    
    class func sharedInstance() -> MINTLPreferencesWindowController?
    {
        if( singletonSharedInstance == nil )
        {
            singletonSharedInstance
                = NSStoryboard(name:"PreferencesWindowController")
                .instantiateInitialController() as! MINTLPreferencesWindowController?            
        }
        
        return singletonSharedInstance
    }
    
    // MARK: - init methods
    
    // MARK: - dealloc
    
    // MARK: - NSCopying, hash, isEqual:
    
    // MARK: - NSCoding methods
    
    // MARK: - restorableState methods
    
    static func restoreWindow(withIdentifier identifier: NSUserInterfaceItemIdentifier,
                              state: NSCoder,
                              completionHandler: @escaping (NSWindow?, Error?) -> Void)
    {
        var theWindow: NSWindow? = nil
        
        if( identifier.rawValue == "PreferencesWindow" )
        {
            theWindow = MINTLPreferencesWindowController.sharedInstance()?.window
        }
        
        completionHandler(theWindow, nil);
    }

    // MARK: - life cycle methods
    
    override func windowDidLoad()
    {
        super.windowDidLoad()
        
        self.window!.restorationClass = MINTLPreferencesWindowController.self
        
        NSUserDefaultsController.shared.appliesImmediately = false
    }

    // MARK: - action methods
    
    @IBAction func showPreferences(_ sender : Any?)
    {
        self.showWindow(sender)
    }

    @objc func canShowPreferences(_ sender : Any?) -> Bool
    {
        return self.window?.isMainWindow == false
    }
    
    @IBAction func revert(_ sender : Any?)
    {
        NSUserDefaultsController.shared.revert(sender)
    }
    
    @objc func canRevert(_ sender : Any?) -> Bool
    {
        return NSUserDefaultsController.shared.hasUnappliedChanges
    }
    
    @IBAction func revertToInitialValues(_ sender : Any?)
    {
        // TODO: 確認のダイアログを表示したい [メッセージ, ok, cancel]
        
        NSUserDefaultsController.shared.revertToInitialValues(sender)
    }
    
    @objc func canRevertToInitialValues(_ sender : Any?) -> Bool
    {
        // いつでも初期値に戻せる
        return true
    }

    @IBAction func save(_ sender : Any?)
    {
        NSUserDefaultsController.shared.save(sender)
    }
    
    @objc func canSave(_ sender : Any?) -> Bool
    {
        return NSUserDefaultsController.shared.hasUnappliedChanges
    }

    // MARK: - event handling methods
    
    // MARK: - drawing methods
    
    // MARK: - delegate/datasource methods
    
    // MARK: - accessor methods (in pairs)
    
    // MARK: - Utility methods

}
