//
//  MINTLSelectedIndexUserInterfaceItem.swift
//  MenuTester
//
//  Created by narita on 2017/08/21.
//  Copyright © 2017年 narita. All rights reserved.
//

import Cocoa


@objc protocol MINTLSelectedIndexUserInterfaceItem
{
    @objc var selectedIndex:NSInteger {get set}
}


extension NSControl : MINTLSelectedIndexUserInterfaceItem
{
    @objc var selectedIndex: NSInteger
    {
        get
        {
            return self.tag
        }
        
        set(value)
        {
            // tagと同じ値であれば Onにする
            self.cell?.state = ( self.tag == value ) ? NSControl.StateValue.init(rawValue:1) : NSControl.StateValue.init(rawValue:0)
        }
    }
}

extension NSMenuItem : MINTLSelectedIndexUserInterfaceItem
{
    @objc var selectedIndex: NSInteger
    {
        get
        {
            return self.tag
        }
        
        set(value)
        {
            // tagと同じ値であれば Onにする
            self.state = ( self.tag == value ) ? NSControl.StateValue.init(rawValue:1) : NSControl.StateValue.init(rawValue:0)
        }
    }
}

// NSMatrixは時代遅れなので、そのうち使えなくなるはず
extension NSMatrix // NSMaxtrixはNSControlなので、MINTLSelectedIndexUserInterfaceItemをサポートしている
{
    @objc override var selectedIndex: NSInteger
    {
        get
        {
            // 最初に見つかったNSOnStateなCellのtagの値を返す
            return self.selectedCells[0].tag
        }
        
        set(value)
        {
            for i in self.cells
            {
                i.state = ( self.tag == value ) ? NSControl.StateValue.init(rawValue:1) : NSControl.StateValue.init(rawValue:0)
            }
        }
    }
}

extension NSSegmentedControl // NSSegmentedControlはNSControlなので、MINTLSelectedIndexUserInterfaceItemをサポートしている
{
    @objc override var selectedIndex: NSInteger
    {
        get
        {
            return self.selectedSegment
        }
        
        set(value)
        {
            self.selectedSegment = value
        }
    }
}

extension NSTabView : MINTLSelectedIndexUserInterfaceItem
{
    @objc var selectedIndex: NSInteger
    {
        get
        {
            if self.selectedTabViewItem != nil
            {
                return self.tabViewItems.index(of: self.selectedTabViewItem!)!
            }
            else
            {
                return NSNotFound
            }
        }
        
        set(value)
        {
            self.selectTabViewItem(at: value)
        }
    }    
}

//extension NSTableView : MINTLSelectedIndexUserInterfaceItem
//{
//    
//    
//}

