//
//  MINTLSplitViewController.swift
//  DateBook
//
//  Created by narita on 2017/09/10.
//  Copyright © 2017年 narita. All rights reserved.
//

import Cocoa

class MINTLSplitViewController: NSSplitViewController
{

    // MARK: - class methods
    
    // MARK: - init methods
    
    // MARK: - dealloc
    
    // MARK: - NSCopying, hash, isEqual:
    
    // MARK: - NSCoding methods
    
    // MARK: - restorableState methods
    
    
    // MARK: - life cycle methods
    
    override func viewDidLoad()
    {
        super.viewDidLoad()
    }
    
    // MARK: - action methods

    @IBAction func toggleFirstSidebar(_ sender: NSObject!)
    {
        if let theFirstItem = self.firstSidebar
        {
            theFirstItem.animator().isCollapsed = !theFirstItem.isCollapsed
        }
    }
    
    @objc func canToggleFirstSidebar(_ sender: NSObject!) -> Bool
    {
        if let theFirstItem = self.firstSidebar
        {
            return theFirstItem.canCollapse == true
        }
        
        return false
    }
    
    @objc func stateOfToggleFirstSidebar(_ sender: NSObject!) -> NSInteger
    {
        if let theFirstItem = self.firstSidebar
        {
            return  theFirstItem.isCollapsed ? 0 : 1
        }
        
        return 0
    }
    
    
    @IBAction func showFirstSidebar(_ sender: NSObject!)
    {
        if self.canShowFirstSidebar(nil)
        {
            if let theFirstItem = self.firstSidebar
            {
                theFirstItem.isCollapsed = false
            }
        }
    }
    
    @objc func canShowFirstSidebar(_ sender: NSObject!) -> Bool
    {
        if let theFirstItem = self.firstSidebar
        {
            return theFirstItem.canCollapse == true && theFirstItem.isCollapsed == true
        }
        
        return false
    }
    
    
    @IBAction func hideFirstSidebar(_ sender: NSObject!)
    {
        if self.canShowFirstSidebar(nil)
        {
            if let theFirstItem = self.firstSidebar
            {
                theFirstItem.isCollapsed = true
            }
        }
    }
    
    @objc func canHideFirstSidebar(_ sender: NSObject!) -> Bool
    {
        if let theFirstItem = self.firstSidebar
        {
            return theFirstItem.canCollapse == true && theFirstItem.isCollapsed == false
        }
        
        return false
    }

    /*
     @IBAction func newCountry(_ sender: NSObject!)
     {
     
     }
     
     @objc func canNewCountry(_ sender: NSObject!) -> Bool
     {

     }
     */
    
    @IBAction func toggleLastSidebar(_ sender: NSObject!)
    {
        if let theLastItem = self.lastSidebar
        {
            theLastItem.animator().isCollapsed = !theLastItem.isCollapsed
        }
    }
    
    @objc func canToggleLastSidebar(_ sender: NSObject!) -> Bool
    {
        if let theLastItem = self.lastSidebar
        {
            return theLastItem.canCollapse == true
        }
        
        return false
    }
    
    @objc func stateOfToggleLastSidebar(_ sender: NSObject!) -> NSInteger
    {
        if let theLastItem = self.lastSidebar
        {
            return  theLastItem.isCollapsed ? 0 : 1
        }

        return 0
    }
    
    
    @IBAction func showLastSidebar(_ sender: NSObject!)
    {
        if self.canShowLastSidebar(nil)
        {
            if let theLastItem = self.lastSidebar
            {
                theLastItem.isCollapsed = false
            }
        }
    }
    
    @objc func canShowLastSidebar(_ sender: NSObject!) -> Bool
    {
        if let theLastItem = self.lastSidebar
        {
            return theLastItem.canCollapse == true && theLastItem.isCollapsed == true
        }
        
        return false
    }
    
    
    @IBAction func hideLastSidebar(_ sender: NSObject!)
    {
        if self.canShowLastSidebar(nil)
        {
            if let theLastItem = self.lastSidebar
            {
                theLastItem.isCollapsed = true
            }
        }
    }
    
    @objc func canHideLastSidebar(_ sender: NSObject!) -> Bool
    {
        if let theLastItem = self.lastSidebar
        {
            return theLastItem.canCollapse == true && theLastItem.isCollapsed == false
        }
        
        return false
    }

    // MARK: - event handling methods
    
    // MARK: - drawing methods
    
    // MARK: - delegate/datasource methods
    
    // MARK: - accessor methods (in pairs)
    
    @objc class func keyPathsForValuesAffectingMainContentsViewController() -> Set<String>
    {
        return [ "splitViewItems", "splitViewItems.behavior" ]
    }

    @objc var mainContentsViewController: NSViewController?
    {
        return self.splitViewItems.filter(
            { $0.behavior == NSSplitViewItem.Behavior.default }).first?.viewController
    }
    
    @objc class func keyPathsForValuesAffectingFirstSidebar() -> Set<String>
    {
        return [ "splitViewItems", "splitViewItems.behavior" ]
    }

    @objc var firstSidebar: NSSplitViewItem?
    {
        return self.splitViewItems.filter({ $0.behavior == NSSplitViewItem.Behavior.sidebar }).first
    }

    @objc class func keyPathsForValuesAffectingLastSidebar() -> Set<String>
    {
        return [ "splitViewItems", "splitViewItems.behavior" ]
    }

    @objc var lastSidebar: NSSplitViewItem?
    {
        return self.splitViewItems.filter({ $0.behavior == NSSplitViewItem.Behavior.sidebar }).last
    }
    
    @objc class func keyPathsForValuesAffectingWindow() -> Set<String>
    {
        return [ "view", "view.window" ]
    }

    @objc open var window: NSWindow?
    {
        return self.view.window
    }

    @objc class func keyPathsForValuesAffectingWindowController() -> Set<String>
    {
        return [ "view", "view.window", "view.window.windowController" ]
    }

    @objc open var windowController: NSWindowController?
    {
        return self.window?.windowController
    }

    @objc class func keyPathsForValuesAffectingDocument() -> Set<String>
    {
        return [ "view", "view.window", "view.window.windowController", "view.window.windowController.document" ]
    }

    @objc open var document: NSDocument?
    {
        return self.windowController?.document as! NSDocument?
    }

    // MARK: - Utility methods

    override func validateUserInterfaceItem(_ item: NSValidatedUserInterfaceItem) -> Bool
    {
        return respondsAndPerformValidatedUserInterface(item)
        {
            super.validateUserInterfaceItem($0)
        }
    }
}
