//
//  MINTLSplitableScrollView.swift
//  ToDoList
//
//  Created by narita on 2017/09/24.
//  Copyright © 2017年 narita. All rights reserved.
//

import Cocoa

class MINTLSplitableScrollView: NSScrollView
{
    // MARK: - class methods
    
    // MARK: - init methods
    
    // MARK: - dealloc
    
    // MARK: - NSCopying, hash, isEqual:
    
    // MARK: - NSCoding methods
    
    // MARK: - restorableState methods
    
    override func encodeRestorableState(with coder: NSCoder)
    {
        super.encodeRestorableState(with: coder)
        
        // スクロール位置の保存
        coder.encode(self.contentView.bounds, forKey: "contentView_bounds")
    }
    
    override func restoreState(with coder: NSCoder)
    {
        super.restoreState(with: coder)
        
        let theRect = coder.decodeRect(forKey: "contentView_bounds")

        self.contentView.scroll(to: theRect.origin)
        self.reflectScrolledClipView(self.contentView)
    }

    // MARK: - life cycle methods
    
    // MARK: - action methods
    
    // MARK: - event handling methods
    
    override func mouseEntered(with event: NSEvent)
    {
        self.vSplitOpenButton!.animator().alphaValue = 0.5
        self.vSplitCloseButton!.animator().alphaValue = 0.5
    }
    
    override func mouseExited(with event: NSEvent)
    {
        self.vSplitOpenButton!.animator().alphaValue = 0.0
        self.vSplitCloseButton!.animator().alphaValue = 0.0
    }
    
    // MARK: - drawing methods
    
    // MARK: - delegate/datasource methods
    
    override func findBarViewDidChangeHeight()
    {
        super.findBarViewDidChangeHeight()
        
        self.vSplitOpenButton!.alphaValue = 0.0
        self.vSplitCloseButton!.alphaValue = 0.0
    }

    // MARK: - accessor methods (in pairs)
    
    @IBOutlet open weak var viewController: NSViewController?

    open var vSplitOpenButton:  NSButton?
    open var vSplitCloseButton: NSButton?
    
    open var splitButtonsTrackingArea: NSTrackingArea?

    // MARK: - Utility methods
    
    func validateUserInterfaceItem(_ item: NSValidatedUserInterfaceItem) -> Bool
    {
        return respondsAndPerformValidatedUserInterface(item)
    }
    
    func makeSidebarbutton(with imageName:String, selector:Selector) -> NSButton?
    {
        let theResult: NSButton = NSButton.init(frame: NSZeroRect)
        
        theResult.setButtonType(.momentaryLight)
        theResult.bezelStyle = .regularSquare
        theResult.isBordered = false
        
        theResult.image = NSImage.init(named: imageName)
        theResult.image?.size = NSMakeSize(12, 12)
        
        theResult.frame.size = NSMakeSize(18, 18)//(theResult.image?.size)!
        
        theResult.imagePosition = .imageOnly
        theResult.imageScaling = .scaleProportionallyDown
        
        theResult.target = self.viewController
        theResult.action = selector
        
        return theResult
    }
    
    override func tile()
    {
        super.tile()
        
        // そして表示アニメーションのための、領域の設定
        if( self.hasVerticalScroller )
        {
            let vScroller: NSScroller? = self.verticalScroller
            let vScrollerFrame   = vScroller!.frame;

            if self.vSplitOpenButton == nil
            {
                self.vSplitOpenButton = self.makeSidebarbutton(with: "splitopen", selector: Selector(("newPane:")))
                self.addSubview(self.vSplitOpenButton! )
                self.vSplitOpenButton!.alphaValue = 0.0
            }
            
            //スクロールバーの幅だけ右のほうへずらす
            self.vSplitOpenButton!.frame.origin.x = vScrollerFrame.origin.x
                                                        - self.vSplitOpenButton!.frame.size.width * 2

            
            if self.vSplitCloseButton == nil
            {
                self.vSplitCloseButton = self.makeSidebarbutton(with: "splitclose", selector: Selector(("deletePane:")))
                self.addSubview(self.vSplitCloseButton! )
                self.vSplitCloseButton!.alphaValue = 0.0
            }

            //スクロールバーの幅だけ右のほうへずらす
            self.vSplitCloseButton!.frame.origin.x = vScrollerFrame.origin.x
                                                        - self.vSplitCloseButton!.frame.size.width
            
            // マウスオーバーの下準備
            if self.splitButtonsTrackingArea != nil
            {
                self.removeTrackingArea(self.splitButtonsTrackingArea!)
                self.splitButtonsTrackingArea = nil
            }
            
            let theButtonsFrame = NSUnionRect((self.vSplitOpenButton?.frame)!, (self.vSplitCloseButton?.frame)!)
            
            self.splitButtonsTrackingArea = NSTrackingArea(rect: theButtonsFrame,
                                                           options: [.mouseEnteredAndExited, .activeAlways],
                                                           owner: self)
            
            self.addTrackingArea(self.splitButtonsTrackingArea!)
        }
    }
}
