//
//  MINTLString2AttributedString.swift
//  MenuTester
//
//  Created by narita on 2017/08/04.
//  Copyright © 2017年 narita. All rights reserved.
//

import Cocoa

@objc(MINTLString2AttributedString)

class MINTLString2AttributedString: ValueTransformer
{
    // MARK: - class methods
    
    override class func transformedValueClass() -> AnyClass
    {
        return NSAttributedString.classForCoder()
    }
    
    override class func allowsReverseTransformation() -> Bool
    {
        return true
    }
    
    // MARK: - init methods
    
    // MARK: - dealloc
    
    // MARK: - NSCopying, hash, isEqual:
    
    // MARK: - NSCoding methods
    
    // MARK: - restorableState methods
    
    // MARK: - life cycle methods
    
    // MARK: - action methods
    
    override func transformedValue(_ value: Any?) -> Any?
    {
        guard let theValue = value  as? String else
        {
            return nil
        }
        
        return NSAttributedString.init(string: theValue)
    }
    
    override func reverseTransformedValue(_ value: Any?) -> Any?
    {
        guard let theValue = value as? NSAttributedString else
        {
            return nil
        }
        
        return theValue.string
    }
    
    // MARK: - event handling methods
    
    // MARK: - drawing methods
    
    // MARK: - delegate/datasource methods
    
    // MARK: - accessor methods (in pairs)
    
    // MARK: - Utility methods
}

extension NSValueTransformerName
{
    static let MINTLString2AttributedStringName = NSValueTransformerName(rawValue: "MINTLString2AttributedString")
}

@objc(MINTLAttributedString2String)

class MINTLAttributedString2String: ValueTransformer
{
    // MARK: - class methods
    
    override class func transformedValueClass() -> AnyClass
    {
        return NSString.classForCoder()
    }
    
    override class func allowsReverseTransformation() -> Bool
    {
        return true
    }
    
    // MARK: - init methods
    
    // MARK: - dealloc
    
    // MARK: - NSCopying, hash, isEqual:
    
    // MARK: - NSCoding methods
    
    // MARK: - restorableState methods
    
    // MARK: - life cycle methods
    
    // MARK: - action methods
    
    override func transformedValue(_ value: Any?) -> Any?
    {
        guard let theValue = value as? NSAttributedString else
        {
            return nil
        }
        
        return theValue.string
    }
    
    override func reverseTransformedValue(_ value: Any?) -> Any?
    {
        guard let theValue = value  as? String else
        {
            return nil
        }
        
        return NSAttributedString.init(string: theValue)
    }
    
    // MARK: - event handling methods
    
    // MARK: - drawing methods
    
    // MARK: - delegate/datasource methods
    
    // MARK: - accessor methods (in pairs)
    
    // MARK: - Utility methods
}

extension NSValueTransformerName
{
    static let MINTLAttributedString2StringName = NSValueTransformerName(rawValue: "MINTLAttributedString2String")
}

