//
//  MINTLViewController.swift
//  CurrencyConverter
//
//  Created by narita on 2017/08/29.
//  Copyright © 2017年 narita. All rights reserved.
//

import Cocoa

class MINTLViewController: NSViewController, NSUserInterfaceValidations
{
    // MARK: - class methods
    
    // MARK: - init methods
    
    // MARK: - dealloc
    
    // MARK: - NSCopying, hash, isEqual:
    
    // MARK: - NSCoding methods
    
    // MARK: - restorableState methods
    
    // MARK: - life cycle methods
    
    // MARK: - action methods
    
    // MARK: - event handling methods
    
    // MARK: - drawing methods
    
    // MARK: - delegate/datasource methods
    
    // MARK: - accessor methods (in pairs)
    
    @objc class func keyPathsForValuesAffectingWindow() -> Set<String>
    {
        return [ "view", "view.window" ]
    }
    
    @objc open var window: NSWindow?
    {
        return self.view.window
    }
    
    @objc class func keyPathsForValuesAffectingWindowController() -> Set<String>
    {
        return [ "view", "view.window", "view.window.windowController" ]
    }
    
    @objc open var windowController: NSWindowController?
    {
        return self.window?.windowController
    }
    
    @objc class func keyPathsForValuesAffectingDocument() -> Set<String>
    {
        return [ "view", "view.window", "view.window.windowController",
                 "view.window.windowController.document" ]
    }
    
    @objc open var document: NSDocument?
    {
        return self.windowController?.document as! NSDocument?
    }
    
    // MARK: - Utility methods
    func validateUserInterfaceItem(_ item: NSValidatedUserInterfaceItem) -> Bool
    {
        return respondsAndPerformValidatedUserInterface(item)
    }
}
