//
//  MINTLWindow.swift
//  MenuTester
//
//  Created by narita on 2017/08/17.
//  Copyright © 2017年 narita. All rights reserved.
//

import Cocoa

class MINTLWindow: NSWindow
{
    // MARK: - class methods
    
    // MARK: - init methods
    
    override public init(contentRect: NSRect,
                         styleMask style: NSWindow.StyleMask,
                         backing backingStoreType: NSWindow.BackingStoreType,
                         defer flag: Bool)
    {
        super.init(contentRect: contentRect,
                   styleMask: style,
                   backing: backingStoreType,
                   defer: flag)
        
        self.autovalidates = true
    }

    // MARK: - dealloc
    
    // MARK: - NSCopying, hash, isEqual:
    
    // MARK: - NSCoding methods
    
    // MARK: - restorableState methods
    
    // MARK: - life cycle methods
    
    // MARK: - action methods
        
    // MARK: - event handling methods
    
    override func update()
    {
        if self.autovalidates == true
        {
            if let theContentsView = self.contentView
            {
                if theContentsView.isHiddenOrHasHiddenAncestor == false
                {
                    theContentsView.updateSubvewsUserInterfaceValidation()
                }
            }
            
            if let theDocument = self.windowController?.document
            {
                self.isDocumentEdited = theDocument.isDocumentEdited
            }
        }
        
        super.update()
    }

    // MARK: - drawing methods
    
    // MARK: - delegate/datasource methods
    
    // MARK: - accessor methods (in pairs)
    
    @IBInspectable var autovalidates: Bool = true

    // MARK: - Utility methods
    
    override func validateUserInterfaceItem(_ item: NSValidatedUserInterfaceItem) -> Bool
    {
        return respondsAndPerformValidatedUserInterface(item)
        {
            super.validateUserInterfaceItem($0)
        }
    }

}

