//
//  MINTLWindowController.swift
//  MenuTester
//
//  Created by narita on 2017/08/03.
//  Copyright © 2017年 narita. All rights reserved.
//

import Cocoa

class MINTLWindowController: NSWindowController, NSUserInterfaceValidations
{
    // MARK: - class methods
    
    // MARK: - init methods
    
    // MARK: - dealloc
    
    // MARK: - NSCopying, hash, isEqual:
    
    // MARK: - NSCoding methods
    
    // MARK: - restorableState methods
    
    // MARK: - life cycle methods
    
    override func windowDidLoad()
    {
        super.windowDidLoad()
    }

    // MARK: - action methods
    
    // MARK: - event handling methods
    
    // MARK: - drawing methods
    
    // MARK: - delegate/datasource methods
    
    // MARK: - accessor methods (in pairs)
    
    @objc class func keyPathsForValuesAffectingShouldCascade() -> Set<String>
    {
        return [ "shouldCascadeWindows" ]
    }

    @IBInspectable var shouldCascade: Bool
    {
        get
        {
            return self.shouldCascadeWindows
        }
        
        set
        {
            self.shouldCascadeWindows = newValue
        }
    }

    override var windowNibName: NSNib.Name?
    {
        get
        {
            let theSuperWindowNibName = super.windowNibName
            
            if theSuperWindowNibName != nil && theSuperWindowNibName?.count != 0
            {
                return theSuperWindowNibName
            }
            
            return NSStringFromClass(self.classForCoder)
        }
    }
    
    // MARK: - Utility methods
    
    func validateUserInterfaceItem(_ item: NSValidatedUserInterfaceItem) -> Bool
    {
        return respondsAndPerformValidatedUserInterface(item)
    }
    
    override func windowTitle(forDocumentDisplayName displayName: String) -> String
    {
        if let theDocument: NSDocument = self.document as! NSDocument?
        {            
            let theWindowControllers = theDocument.windowControllers
            
            if theWindowControllers.count > 1
            {
                let theIndex = theWindowControllers.index(of: self)! + 1
                let theName  = theDocument.displayName!
                
                return "\(String(describing: theName)):\(String(describing: theIndex))"
            }
        }
        
        return super.windowTitle(forDocumentDisplayName: displayName)
    }

    open func synchronizeUserInterfaceIdentifier()
    {
        if let theDocument: NSDocument = self.document as! NSDocument?
        {
            let theIndex:NSInteger = theDocument.windowControllers.index(of:self)!
                        
            self.window?.identifier =
                NSUserInterfaceItemIdentifier(rawValue: "\(self.classForCoder):\(theIndex)")
        }
    }
}
