//
//  File.swift
//  DateBook
//
//  Created by narita on 2017/09/06.
//  Copyright © 2017年 narita. All rights reserved.
//

import Cocoa

// KVC/KVO可能なプロパティの存在確認
extension NSObject
{
    // プロパティーの読み書きが可能か否か？
    public enum EPropertyAttribute : UInt
    {
        case none
        case readOnly
        case readWrite
    }

    func propertyExists(at name: String) -> EPropertyAttribute
    {
        var theResult:EPropertyAttribute = .none
        
        if self.responds(to: NSSelectorFromString(name) )
        {
            theResult = .readOnly;
        }

        if self.responds(to: setterSelectorFromString(name) )
        {
            if theResult == .readOnly
            {
                theResult = .readWrite
            }
        }
        
        return theResult
    }    
}
