//
//  NSStoryboard+MINTLExtension.swift
//  ControlSikenjo
//
//  Created by narita on 2018/12/04.
//  Copyright © 2018 narita. All rights reserved.
//

import AppKit
import Foundation

extension NSStoryboard
{
    // mainBundle中(Frameworkにする場合はBundle指定。あるいは、Framework専用のinitを作っても良いかも)
    public convenience init(name: NSStoryboard.Name)
    {
        self.init(name: name, bundle: nil)
    }

    
    // for NSWindowController
    open func instantiateInitialWindowController() -> NSWindowController?
    {
        return instantiateInitialController() as? NSWindowController
    }
    
    
    open func instantiateWindowController(withIdentifier identifier: NSStoryboard.SceneIdentifier) -> NSWindowController
    {
        return instantiateController(withIdentifier: identifier) as! NSWindowController
    }

    // for NSViewController
    open func instantiateInitialViewController() -> NSViewController?
    {
        return instantiateInitialController() as? NSViewController
    }
    
    
    open func instantiateViewController(withIdentifier identifier: NSStoryboard.SceneIdentifier) -> NSViewController
    {
        return instantiateController(withIdentifier: identifier) as! NSViewController
    }
}
