//
//  NSString+MINTLExtensions.swift
//  MenuTester
//
//  Created by narita on 2017/08/18.
//  Copyright © 2017年 narita. All rights reserved.
//

import Foundation

func makePrefixedSelector(prefix: String, base: Selector) -> Selector
{
    let theBaseString = NSStringFromSelector(base) as NSString
    
    //    1文字目を大文字にする
    let theFirstString: NSString = theBaseString.substring(to:1).uppercased() as NSString
    
    //    2文字目以降はそのまま
    let theOtherString: NSString = theBaseString.substring(with: NSMakeRange(1, theBaseString.length-1)) as NSString
    
    return NSSelectorFromString(prefix.appending(theFirstString.appending(theOtherString as String)))
}

func setterSelectorFromString(_ string: String) -> Selector
{
    let theName = string as NSString
    
    let theFirstString = theName.substring(to:1).uppercased()
    let theOtherString = theName.substring(with: NSMakeRange(1, theName.length-1))
    
    let theSelectorString = String.init(format: "set%@%@:", theFirstString, theOtherString)
    
    return NSSelectorFromString(theSelectorString)
}

extension String
{
    // https://qiita.com/codelynx/items/183b29c95110e0dc05db
    // 行に分解
    var lines: [String]
    {
        var lines = [String]()
        
        self.enumerateLines
        {
            (line, stop) -> () in
            
            lines.append(line)
        }
        
        return lines
    }
}
