//
//  NSUserDefaults+MINTLExtensions.swift
//  MenuTester
//
//  Created by narita on 2017/08/03.
//  Copyright © 2017年 narita. All rights reserved.
//

import Cocoa

extension UserDefaults
{
    class func setupDefaults()
    {
        // ユーザデフォルトに使用するデフォルト値を読み込む
        guard
            let theUserDefaultsValuesPath = Bundle.main.path(forResource: "UserDefaults",
                                                             ofType: "plist")
            else
        {
            return
        }
        
        guard
            let theUserDefaultsValuesDict = NSDictionary(contentsOfFile: theUserDefaultsValuesPath) as? [String: Any]
            else
        {
            return
        }
        
        // 読み込んだ値を標準ユーザデフォルトに設定
        UserDefaults.standard.register(defaults: theUserDefaultsValuesDict)
        NSUserDefaultsController.shared.initialValues = theUserDefaultsValuesDict
    }
}
