//
//  TVFViewController.swift
//  TableViewFinder
//
//  Created by narita on 2017/11/14.
//  Copyright © 2017年 narita. All rights reserved.
//

import Cocoa

func range2NSRange(_ range: Range<Int>) -> NSRange
{
    let theLower = range.lowerBound
    let theUpper = range.upperBound
    
    return NSRange(location: theLower, length: theLower.distance(to: theUpper))
}

extension TVFViewController
{
    // MARK: - class methods
    
    // MARK: - init methods
    
    // MARK: - dealloc
    
    // MARK: - NSCopying, hash, isEqual:
    
    // MARK: - NSCoding methods
    
    // MARK: - restorableState methods
    
    // MARK: - life cycle methods
    
    
    // MARK: - action methods
    
    @IBAction override func performTextFinderAction(_ sender: Any?)
    {
        if let theControl = sender as? NSValidatedUserInterfaceItem
        {
            let theAction: NSTextFinder.Action = NSTextFinder.Action(rawValue: theControl.tag)!
            
            self.textFinder!.performAction(theAction)
        }
    }

    func validateUserInterfaceItem(_ sender: Any?) -> Bool
    {
        if let theControl = sender as? NSValidatedUserInterfaceItem
        {
            if theControl.action == #selector(NSResponder.performTextFinderAction(_:))
            {
                let theAction: NSTextFinder.Action = NSTextFinder.Action(rawValue: theControl.tag)!
                
                return self.textFinder!.validateAction(theAction)
            }
        }
        
        return false
    }

    // MARK: - event handling methods
    
    // MARK: - drawing methods
    
    // MARK: - delegate/datasource methods
    
    public func stringLength() -> Int
    {
        return self.allStringLength
    }

    public func string(at characterIndex: Int,
                       effectiveRange outRange: NSRangePointer,
                       endsWithSearchBoundary outFlag: UnsafeMutablePointer<ObjCBool>) -> String
    {
        if let theTouple = self.indexTupleFrom(location: characterIndex)
        {
            // arrangedObjectsをswiftのArrayへ型変換しない事。Dynamic castは実行時のオーバーヘッドが大きすぎる。
            let theArray: NSArray? = self.arrayController?.arrangedObjects as! NSArray?
            
            // 1個だけの型変換ならば十分にオーバーヘッドは小さい。
            let theString: String = theArray![theTouple.row] as! String

            outRange.pointee.location = theTouple.range.lowerBound
            outRange.pointee.length = theTouple.range.upperBound - theTouple.range.lowerBound
            
            outFlag.pointee = true
            
            return theString
        }
        
        return ""
    }
    
    public func scrollRangeToVisible(_ range: NSRange)
    {
        if let theRow = self.indexTupleFrom(location: range.location)?.row
        {
            self.tableView?.scrollRowToVisible(theRow)
        }
    }
    
    public func contentView(at index: Int, effectiveCharacterRange outRange: NSRangePointer) -> NSView
    {
        let theTouple = self.indexTupleFrom(location: index)!
        
        outRange.pointee.location = theTouple.range.lowerBound
        outRange.pointee.length = theTouple.range.upperBound - theTouple.range.lowerBound
        
        let theCellView: NSTableCellView = self.tableView?.view(atColumn: 0,
                                                                row: theTouple.row,
                                                                makeIfNecessary: true) as! NSTableCellView
        
        return theCellView.textField!
    }
    
    public func rects(forCharacterRange range: NSRange) -> [NSValue]?
    {
        let theTouple = self.indexTupleFrom(location: range.location)!
        
        let theRow = theTouple.row
        let theOffset = theTouple.range.lowerBound
        let theLocalRange = NSRange(location: range.location - theOffset, length: range.length)
        
        let theCellView: NSTableCellView = self.tableView?.view(atColumn: 0,
                                                                row: theRow,
                                                                makeIfNecessary: true) as! NSTableCellView
        
        let theTextField = theCellView.textField!
        let theTextFieldSize = theTextField.bounds.size
        let theAtrString = theTextField.attributedStringValue
        
        // 文字列theAtrStringをtheLocalRangeで指定される範囲の描画矩形を算出する。
        // A. 0文字目から、theLocalRangeのお尻までの矩形の算出
        // B. 0文字目から、theLocalRangeの頭までの矩形の算出
        // C. Aの矩形からBの矩形を引くと(幅は)、目的のtheLoaclRangeの矩形になる。ハズ
        
        let theAStr = theAtrString.attributedSubstring(from: NSRange(location:0,
                                                                     length: theLocalRange.location + theLocalRange.length))
        
        let theBStr = theAtrString.attributedSubstring(from: NSRange(location:0,
                                                                     length: theLocalRange.location))
        
        let theRectA = theAStr.boundingRect(with: theTextFieldSize, options: [], context: nil)
        let theRectB = theBStr.boundingRect(with: theTextFieldSize, options: [], context: nil)
        
        var theRect = theRectA
        theRect.origin.x   = ceil(theRectB.maxX)
        theRect.origin.y   = ceil(theRect.origin.y)
        theRect.size.width = ceil(theRectA.maxX) - ceil(theRectB.maxX)
        theRect.size.height = ceil(theRect.size.height)
        
        return [NSValue(rect:theRect)]
    }
    
    public func drawCharacters(in range: NSRange, forContentView view: NSView)
    {
        let theRectArray = self.rects(forCharacterRange: range)
        
        for theRectValue: NSValue in theRectArray!
        {
            // ToDo: 文字列をrangeで限定すること。そうしないと、文字の端にrange外の文字の端っこが表示されてしまう
            //
            
            view.draw(theRectValue.rectValue)
        }
    }
    
    public var visibleCharacterRanges: [NSValue]
    {
        get
        {
            let theMatches = self.textFinder!.incrementalMatchRanges
            
            if theMatches.isEmpty
            {
                return []
            }
            
            // 表示されている最初と最後の行を求める。
            // 最初の行の最初の文字のIndexと、最後の行の最後の文字のIndexが返すべき値。
            
            let theVisibleRect     = self.tableView!.visibleRect
            let theVisibleRowRange = self.tableView!.rows(in: theVisibleRect)
            let theFirstVisibleRow = theVisibleRowRange.location
            let theLastVisibleRow  = theVisibleRowRange.upperBound - 1
            
            let theFirstDict = finderIndex![theFirstVisibleRow]
            let theFirstIndex = theFirstDict.range.lowerBound
            
            let theLastDict  = finderIndex![theLastVisibleRow]
            let theLastIndex = theLastDict.range.upperBound
            
            return [ NSValue(range: NSRange(location:theFirstIndex, length: theLastIndex)) ]
        }
    }

    
    // MARK: - accessor methods (in pairs)
    
    var isSelectable: Bool
    {
        get { return true }
    }
    
    var allowsMultipleSelection: Bool
    {
        get { return false   }
    }
    
    var isEditable: Bool
    {
        get { return false }
    }
    
    var firstSelectedRange: NSRange
    {
        get
        {
            if self.tableView!.selectedRow != -1
            {
                let theRange = self.finderIndex![self.tableView!.selectedRow].range
                
                return range2NSRange(theRange)
            }
            
            return NSRange(location: 0, length: 0)
        }
    }
    
    var selectedRanges: [NSValue]
    {
        get
        {
            return [NSValue(range:self.firstSelectedRange)]
        }
        
        set(ranges)
        {
            if ranges.isEmpty
            {
                self.tableView!.deselectAll(nil)
            }
            else
            {
                let theRange = ranges.first!.rangeValue
                
                if let theRow = self.indexTupleFrom(location: theRange.location)?.row
                {
                    let theIndexSet: IndexSet = IndexSet([theRow])
                    self.tableView?.selectRowIndexes(theIndexSet,
                                                     byExtendingSelection: false)
                }
            }
        }
    }

    
    // MARK: - Utility methods
}

