//
//  TVFViewController.swift
//  TableViewFinder
//
//  Created by narita on 2017/11/14.
//  Copyright © 2017年 narita. All rights reserved.
//

import Cocoa

@objc class TVFViewController: NSViewController, NSTextFinderClient
{
    // MARK: - class methods
    
    // MARK: - init methods
    
    // MARK: - dealloc
    
    // MARK: - NSCopying, hash, isEqual:
    
    // MARK: - NSCoding methods
    
    // MARK: - restorableState methods
    
    // MARK: - life cycle methods
    
    override func viewDidLoad()
    {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        
        self.textFinder = NSTextFinder()
        self.textFinder!.client = self
        self.textFinder!.findBarContainer = self.tableView!.enclosingScrollView

        self.textFinder!.isIncrementalSearchingEnabled = true
        self.textFinder!.incrementalSearchingShouldDimContentView = true
        
        // NSArrayControllerのarrangedArrayが変更された場合は、サーチ用の
        // データを再構築させるために、無効にする
        self.arrangedObjectsObservation = observe(\.arrayController?.arrangedObjects)
        {_,_ in
            self.setNeedUpdateFinderIndex()
        }
    }
    
    // MARK: - action methods
    
    // MARK: - event handling methods
    
    // MARK: - drawing methods
    
    // MARK: - delegate/datasource methods
    
    // MARK: - accessor methods (in pairs)
    
    @objc @IBOutlet var arrayController: NSArrayController? = nil
    
    @objc @IBOutlet var tableView: NSTableView? = nil

    override var representedObject: Any?
    {
        didSet
        {
            // Update the view, if already loaded.
        }
    }
    
    @objc var words: NSSet?
    {
        if let theWords = (NSApp.delegate as! NSObject).value(forKey: "words")
        {
            return theWords as? NSSet
        }
        
        return nil
    }

    
    @objc var textFinder: NSTextFinder? = nil
    
    var arrangedObjectsObservation: NSKeyValueObservation? = nil   // KVOでarrayControllerの配列を監視

    // index: その行の最初の文字が、TableView全体の文字列からみて何文字目であるかを示すindex
    // row:行番号
    private var _finderIndex: Array<(range: Range<Int>, row: Int)>?
    
    var finderIndex: Array<(range: Range<Int>, row: Int)>?
    {
        get
        {
            if self._finderIndex == nil
            {
                self.calculateFinderIndex()
            }
            
            return self._finderIndex
        }
    }
    
    // TableView全体の文字列長さ
    var allStringLength: Int
    {
        get
        {
            if self._finderIndex == nil
            {
                self.calculateFinderIndex()
            }
            
            return (self._finderIndex?.last?.range.upperBound)!
        }
    }

    // MARK: - Utility methods
    
    func setNeedUpdateFinderIndex()
    {
        self.textFinder!.noteClientStringWillChange()

        self._finderIndex = nil
    }
    
    // 部分文字列の位置を計算
    private func calculateFinderIndex()
    {
        self._finderIndex = [] //前のインデックスをクリアする
        
        if let theArray = self.arrayController?.arrangedObjects as? Array<String>
        {
            // 前の値に加算する系の定石があった気がするが名前を忘れたのループで書いた。

            var theAccumulatedIndex = 0 // 行頭の文字のindex

            for (i, v) in theArray.enumerated()
            {
                // NSStringに変換するのは、NSTextFinderがNSStringでの文字列長に依存と思われるため
                let theLength = (v as NSString).length
                let theRange: Range<Int> = theAccumulatedIndex ..< theAccumulatedIndex + theLength
                
                self._finderIndex!.append((range: theRange, row: i))
                
                theAccumulatedIndex = theAccumulatedIndex + theLength
            }
        }
    }
    
    func indexTupleFrom(location: Int) -> (range: Range<Int>, row: Int)?
    {
        // バイナリサーチで探す。
        // todo: 標準ライブラリで用意されているかもしれないので探す事。
        func binarySearch(loc: Int, range: Range<Int>/*_finderIndex中での範囲*/) -> Int?
        {

            if range.lowerBound >= range.upperBound
            {
                return nil
            }
            else
            {
                let theMiddleIndex = range.lowerBound + (range.upperBound - range.lowerBound) / 2
                let theMiddleRange = self._finderIndex![theMiddleIndex].range
                
                if theMiddleRange.contains(loc)
                {
                    return theMiddleIndex
                }
                else if theMiddleRange.lowerBound < loc
                {
                    return binarySearch(loc: loc, range: theMiddleIndex + 1 ..< range.upperBound)
                }
                else if theMiddleRange.upperBound > loc
                {
                    return binarySearch(loc: loc, range: range.lowerBound ..< theMiddleIndex)
                }

                // ここには来てはいけない。
                
                return nil
            }
        }
        
        var theResult: (range: Range<Int>, row: Int)?
        
        if let theRow = binarySearch(loc: location, range: 0 ..< self._finderIndex!.count)
        {
            theResult = self._finderIndex![theRow]
        }
        
        return theResult
    }

}

