//
//  AppDelegate.swift
//  PasteboardApp
//
//  Created by narita on 2018/10/20.
//  Copyright © 2018 narita. All rights reserved.
//

import Cocoa

@NSApplicationMain
class AppDelegate: NSObject, NSApplicationDelegate
{
    // MARK: - class methods
    
    static func PBAppDelegate() -> AppDelegate!
    {
        return NSApp.delegate as? AppDelegate
    }
    
    // MARK: - init methods
    
    // MARK: - dealloc
    
    // MARK: - NSCopying, hash, isEqual:
    
    // MARK: - NSCoding methods
    
    // MARK: - restorableState methods
    
    // MARK: - life cycle methods
    
    // MARK: - action methods
    
    // MARK: - event handling methods
    
    // MARK: - drawing methods
    
    // MARK: - delegate/datasource methods

    func applicationDidFinishLaunching(_ aNotification: Notification)
    {
        AppDelegate.PBAppDelegate()?.model.startTimer(nil)
    }

    func applicationWillTerminate(_ aNotification: Notification)
    {
        AppDelegate.PBAppDelegate()?.model.stopTimer(nil)
    }
    
    // MARK: - accessor methods (in pairs)
    
    lazy var model: PBModel =
    {
        return PBModel()
    }()

    // MARK: - Utility methods
    
}

