//
//  PBModel.swift
//  PasteboardApp
//
//  Created by narita on 2018/10/25.
//  Copyright © 2018 narita. All rights reserved.
//

import Cocoa

class PBModel: NSObject
{
    // MARK: - class methods
    
    // MARK: - init methods
    
    public override init()
    {
        self.items.append(PBModelItem(name: .general))
        self.items.append(PBModelItem(name: .font))
        self.items.append(PBModelItem(name: .ruler))
        self.items.append(PBModelItem(name: .find))
        self.items.append(PBModelItem(name: .drag))
    }

    // MARK: - dealloc
    
    // MARK: - NSCopying, hash, isEqual:
    
    // MARK: - NSCoding methods
    
    // MARK: - restorableState methods
    
    // MARK: - life cycle methods
    
    // MARK: - action methods
    
    @objc func startTimer(_ sender: Any?)
    {
        if self.timer == nil
        {
            // タイマーでてポーリングが定石らしい
            self.timer = Timer.scheduledTimer(timeInterval: 0.1,
                                              target: self,
                                              selector: #selector(PBModel.updateItems(_:)),
                                              userInfo: nil,
                                              repeats: true)
        }
    }

    @objc func stopTimer(_ sender: Any?)
    {
        // ポーリングの停止
        if self.timer != nil
        {
            self.timer!.invalidate()
            self.timer = nil
        }
    }

    static let updateNotificationName = Notification.Name("PBModelUpdateNotification")

    @objc func updateItems(_ sender: Any?)
    {
        var isUpdate: Bool = false
        
        self.items.forEach
        {
            i in
            
            if i.update()
            {
                isUpdate = true
            }
        }
        
        // 本来は個々にKVOで行うべきだが、メンドくさいのでNotificationを飛ばす
        if isUpdate
        {
            let theNC = NotificationCenter.default
            
            theNC.post(name: PBModel.updateNotificationName,
                       object: nil)
        }
    }
    
    // MARK: - event handling methods
    
    // MARK: - drawing methods
    
    // MARK: - delegate/datasource methods
    
    // MARK: - accessor methods (in pairs)
    
    // ポーリング用のタイマー
    var timer: Timer? = nil

    var items: Array<PBModelItem> = Array()

    // MARK: - Utility methods
}
