//
//  PBModelItem.swift
//  PasteboardApp
//
//  Created by narita on 2018/10/25.
//  Copyright © 2018 narita. All rights reserved.
//

import Cocoa

class PBModelItem: NSObject
{
    // MARK: - class methods
    
    // MARK: - init methods
    
    public init(name: NSPasteboard.Name)
    {
        self.name = name
    }

    // MARK: - dealloc
    
    // MARK: - NSCopying, hash, isEqual:
    
    // MARK: - NSCoding methods
    
    // MARK: - restorableState methods
    
    // MARK: - life cycle methods
    
    // MARK: - action methods

    func update() -> Bool
    {
        if self.oldChangeCount != self.pasteboard.changeCount
        {
            self.oldChangeCount = self.pasteboard.changeCount

            return true
        }

        return false
    }
    
    // MARK: - event handling methods
    
    // MARK: - drawing methods
    
    // MARK: - delegate/datasource methods
    
    // MARK: - accessor methods (in pairs)
    
    public override class func keyPathsForValuesAffectingValue(forKey key: String) -> Set<String>
    {
        if key == "pasteboard"
        {
            return Set(["name", "oldChangeCount"])
        }
        else
        {
            return super.keyPathsForValuesAffectingValue(forKey: key)
        }
    }
    
    @objc dynamic var name: NSPasteboard.Name
    
    @objc dynamic var pasteboard: NSPasteboard
    {
        get
        {
            return NSPasteboard.init(name: self.name)
        }
    }
    
    @objc dynamic var oldChangeCount: Int = 0

    // MARK: - Utility methods
}
