//
//  ViewController.swift
//  PasteboardApp
//
//  Created by narita on 2018/10/20.
//  Copyright © 2018 narita. All rights reserved.
//

import Cocoa

class ViewController: NSViewController, NSBrowserDelegate
{
    // MARK: - class methods
    
    // MARK: - init methods
    
    // MARK: - dealloc
    
    // MARK: - NSCopying, hash, isEqual:
    
    // MARK: - NSCoding methods
    
    // MARK: - restorableState methods
    
    // MARK: - life cycle methods

    override func viewDidLoad()
    {
        super.viewDidLoad()
    }


    override func viewDidAppear()
    {
        let theNC = NotificationCenter.default
        
        theNC.addObserver(forName: PBModel.updateNotificationName,
                          object: nil,
                          queue: nil)
        {
            _ in
            
            if let theBrowser = self.browserView as NSBrowser?
            {
                
                let theIndexPath = self.browserView!.selectionIndexPath
                
                theBrowser.reloadColumn(0)
                theBrowser.reloadColumn(1)
                theBrowser.reloadColumn(2)

                // 選択可能か確認しながら選択する。
                if let indexPath = theIndexPath as NSIndexPath?
                {
                    for i in 0 ..< indexPath.length
                    {
                        if i <= theBrowser.lastColumn
                        {
                            let e = indexPath.index(atPosition: i)

                            theBrowser.selectRow(e, inColumn: i)
                        }
                    }
                }
            }
            
            self.updateTextView(nil)
            
        }
        
        self.textView!.font = NSFont.userFixedPitchFont(ofSize: 16)
    }
    
    override func viewWillDisappear()
    {

    }

    // MARK: - action methods
    
    @IBAction func updateTextView(_ sender: Any?)
    {
        // 3行目のカラムが選択されている場合に更新
        if self.browserView!.selectedColumn == 2
        {
            let the0Row = self.browserView!.selectedRow(inColumn: 0)
            let the1Row = self.browserView!.selectedRow(inColumn: 1)
            let the2Row = self.browserView!.selectedRow(inColumn: 2)

            if let theModel = AppDelegate.PBAppDelegate()?.model as PBModel?
            {
                let thePBModelItem:    PBModelItem                 = theModel.items[the0Row]
                let thePasteboard:     NSPasteboard                = thePBModelItem.pasteboard
                let thePasteboardItem: NSPasteboardItem            = thePasteboard.pasteboardItems![the1Row]
                let thePasteboardType: NSPasteboard.PasteboardType = thePasteboardItem.types[the2Row]

                
                let theData = thePasteboardItem.data(forType: thePasteboardType)
                
                // Hex/Ascii Dump したい
                if let theUnwrapData = theData as Data?
                {
                    self.textView?.string = hexDumpStringForBytes(bytes: theUnwrapData)
                }
            }
        }
        else
        {
            // それ以外は、空白に戻す。
            self.textView?.string = ""
        }
    }
    
    // MARK: - event handling methods

    // MARK: - drawing methods
    
    // MARK: - delegate/datasource methods
    
    public func rootItem(for browser: NSBrowser) -> Any?
    {
        return AppDelegate.PBAppDelegate()?.model
    }

    
    public func browser(_ browser: NSBrowser, numberOfChildrenOfItem item: Any?) -> Int
    {
        var theResult: Int = 0
        
        switch item
        {
            case is PBModel:
                if let theModel = item as? PBModel
                {
                    theResult = theModel.items.count
                }

            case is PBModelItem:
                if let theModelItem = item as? PBModelItem
                {
                    theResult = theModelItem.pasteboard.pasteboardItems!.count
                }
            
            case is NSPasteboardItem:
                if let thePasteboardItem = item as? NSPasteboardItem
                {
                    theResult = thePasteboardItem.types.count
                }

            default:
                theResult = 0
        }
        
        return theResult
    }


    public func browser(_ browser: NSBrowser, child index: Int, ofItem item: Any?) -> Any
    {
        var theResult: Any = "Default"
        
        switch item
        {
            case is PBModel:
                if let theModel = item as? PBModel
                {
                    theResult = theModel.items[index] // PBModelItemを返す
                }
            
            case is PBModelItem:
                if let theModelItem = item as? PBModelItem
                {
                    theResult = theModelItem.pasteboard.pasteboardItems![index]
                }

            case is NSPasteboardItem:
                if let thePasteboardItem = item as? NSPasteboardItem
                {
                    theResult = thePasteboardItem.types[index] // NSPasteboardType
                }
            
            default:
                theResult = "Error"
        }
        
        return theResult
    }


    public func browser(_ browser: NSBrowser, isLeafItem item: Any?) -> Bool
    {
        var theResult: Bool = true
        
        switch item
        {
            case is PBModel:
                if let theModel = item as? PBModel
                {
                    theResult = theModel.items.count == 0
                }
            
            case is PBModelItem:
                if let theModelItem = item as? PBModelItem
                {
                    theResult = theModelItem.pasteboard.pasteboardItems!.count == 0
                }

            case is NSPasteboardItem:
                if let thePasteboardItem = item as? NSPasteboardItem
                {
                    theResult = thePasteboardItem.types.count == 0
                }

            case is NSPasteboard.PasteboardType:
                theResult = true
            
            default:
                theResult = true
        }
        
        return theResult
    }


    public func browser(_ browser: NSBrowser, objectValueForItem item: Any?) -> Any?
    {
        var theResult: Any? = nil
        
        switch item
        {
            case is PBModel:
                if let theModel = item as? PBModel
                {
                    theResult = theModel.description
                }
            
            case is PBModelItem:
                if let theModelItem = item as? PBModelItem
                {
                    theResult = theModelItem.pasteboard.name
                }

            case is NSPasteboardItem:
                if let thePasteboardItem = item as? NSPasteboardItem
                {
                    theResult = thePasteboardItem.description
                }

            case is NSPasteboard.PasteboardType:
                if let thePasteboardType = item as? NSPasteboard.PasteboardType
                {
                    theResult = thePasteboardType.rawValue
                }

            
            default:
                theResult = "DebugString"
        }
        
        return theResult

    }

    public func browser(_ browser: NSBrowser, titleOfColumn: Int) -> String?
    {
        switch titleOfColumn
        {
            case 0:
                 return "NSPastebord.name"

            case 1:
                 return "NSPasteboardItem"

            case 2:
                 return "UTI"

            default:
                return "untitled"
        }
    }

    public func browser(_ browser: NSBrowser, selectionIndexesForProposedSelection proposedSelectionIndexes: IndexSet, inColumn column: Int) -> IndexSet
    {
        self.perform(#selector(ViewController.updateTextView(_:)),
                     with: nil,
                     afterDelay: 0.0)
        
        return proposedSelectionIndexes
    }

    // MARK: - accessor methods (in pairs)

    override var representedObject: Any?
    {
        didSet
        {
            // Update the view, if already loaded.
        }
    }
    
    @IBOutlet var browserView: NSBrowser? = nil
    @IBOutlet var textView: NSTextView? = nil
    // テキスト
    
    // 画像
    
    // 動画
    
    //
    
    // MARK: - Utility methods
}
