//
//  MINTLKeyTouchView.swift
//  KeyTouchViewer
//
//  Created by narita on 2020/02/10.
//  Copyright © 2020 narita. All rights reserved.
//

import Cocoa

// "https://lowreal.net/2014/08/07/1"を参考に作成

class MINTLKeyTouchView: NSView
{
    // MARK: - class methods
    
    // MARK: - init methods
    
    // MARK: - dealloc
    
    // MARK: - NSCopying, hash, isEqual:
    
    // MARK: - NSCoding methods
    
    // MARK: - restorableState methods
    
    // MARK: - life cycle methods
    
    
    override func viewWillMove(toWindow newWindow: NSWindow?)
    {
        super.viewWillMove(toWindow: newWindow)
        
        if newWindow != nil
        {
            // 追加
            self.localEventsMonitorRef =
                NSEvent.addLocalMonitorForEvents(matching: [.keyDown])
                    {
                        (inEvent) -> NSEvent? in
                        
                        let theMod = inEvent.modifierKeyString()
                        
                        let theChar = inEvent.readable()
                        
                        // 1. 改行
                        if theMod == "" && theChar == "↵"
                        {
                            if let theLastObject = self.stringArray.lastObject as? String
                            {
                                self.stringArray.removeLastObject()
                                self.stringArray.add("\(String(describing: theLastObject))\(theChar)")
                            }
                            
                            self.stringArray.add("") // 改行の結果として空の行を追加する
                        }
                        else if theMod == "" || theMod == "⇧" // 2.文字の入力として扱う。
                        {
                            if let theLastObject = self.stringArray.lastObject as? String
                            {
                                self.stringArray.removeLastObject()
                                self.stringArray.add("\(String(describing: theLastObject))\(theChar)")
                            }
                        }
                        else // 3.キーボードショートカットとして扱う
                        {
                            if let theLastObject = self.stringArray.lastObject as? String
                            {
                                if theLastObject == ""
                                {
                                    self.stringArray.removeLastObject()
                                }
                                
                                self.stringArray.add("\(theMod) \(theChar.uppercased())")
                                self.stringArray.add("") // 空の行を追加する
                            }
                                                        
                        }
                        
                        self.needsDisplay = true
                        
                        // 7行以上あれば最初の行を削除する
                        if self.stringArray.count > 7
                        {
                            self.stringArray.removeObjects(in: NSRange(location: 0, length: 1))
                        }
                        
                        return inEvent
                    }
        }
        else
        {
            // 削除
            NSEvent.removeMonitor(self.localEventsMonitorRef!)
            self.localEventsMonitorRef = nil
        }
    }
    
    // MARK: - action methods
    
    // MARK: - event handling methods
    
    // MARK: - drawing methods
    
    override func draw(_ dirtyRect: NSRect)
    {
        super.draw(dirtyRect)
        
        NSColor.clear.set()
        self.bounds.fill()
        
        let theFont = NSFont.boldSystemFont(ofSize: 36.0)
        
        let theShadow = NSShadow()
        theShadow.shadowColor = NSColor.black
        theShadow.shadowBlurRadius = 2.0
        theShadow.shadowOffset = CGSize(width: 0, height: 0)
        
        let theAttrs = [
            NSAttributedString.Key.foregroundColor : NSColor.white,
            NSAttributedString.Key.font            : theFont,
            NSAttributedString.Key.shadow          : theShadow]
                
        var thePoint = NSPoint(x:theShadow.shadowBlurRadius,
                               y:theShadow.shadowBlurRadius)
        
        for i in stringArray.reversed()
        {
            if let theString: NSString = i as? NSString
            {
                let theSize = theString.size(withAttributes:theAttrs)
                
                theString.draw(at: thePoint,
                               withAttributes:theAttrs)

                thePoint.y = thePoint.y + theSize.height
            }
        }
    }
    
    // MARK: - delegate/datasource methods
    
    // MARK: - accessor methods (in pairs)
    
    @objc var localEventsMonitorRef: Any? = nil
    
    @objc var stringArray: NSMutableArray = [""]
    
    // MARK: - Utility methods
    
    
}
