//
//  NSEvent+MINTLExtension.swift
//  KeyTouchViewer
//
//  Created by narita on 2020/02/11.
//  Copyright © 2020 narita. All rights reserved.
//

import Cocoa

extension NSEvent
{
    
    @objc func modifierKeyString() -> String
    {
        var theMod = ""
        
        if self.modifierFlags.contains(.shift)   { theMod += "⇧" }
        
        if self.modifierFlags.contains(.control) { theMod += "^" }
        
        if self.modifierFlags.contains(.option)  { theMod += "⌥" }
        
        if self.modifierFlags.contains(.command)  { theMod += "⌘" }
        
        return theMod
    }
    
    // Unicodeの技術用記号を参考にする
    // https://searchcode.com/codesearch/view/29926166/
    // https://developer.apple.com/documentation/appkit/1540619-common_unicode_characters?language=objc
    // http://www9.plala.or.jp/sgwr-t/c_sub/ascii.html


    @objc func readable() -> String
    {
        if let theFirst = self.charactersIgnoringModifiers?.first
        {
            // ローカル関数
            func KEYSTR(_ inKey:Int) -> String
            {
                return String(format: "%C", inKey)
            }
            
            let theTable = [
                "\u{1b}" : "␛", // ESC
                " "      : "␣", // SPACE
                
                KEYSTR(NSEnterCharacter)              : "⌤",                             // 0x0003
                KEYSTR(NSBackspaceCharacter)          : "⌫",                             // 0x0008
                KEYSTR(NSTabCharacter)                : "⇥",                             // 0x0009
                KEYSTR(NSNewlineCharacter)            : "␊",                             // 0x000a
                KEYSTR(NSFormFeedCharacter)           : "␌",                             // 0x000c
                KEYSTR(NSCarriageReturnCharacter)     : "↵",                             // 0x000d
                KEYSTR(NSBackTabCharacter)            : "⇤",                             // 0x0019
                KEYSTR(NSDeleteCharacter)             : "⌫",                             // 0x007f
                KEYSTR(NSLineSeparatorCharacter)      : "NSLineSeparatorCharacter",      // 0x2028
                KEYSTR(NSParagraphSeparatorCharacter) : "NSParagraphSeparatorCharacter", // 0x2029

                
                KEYSTR(NSUpArrowFunctionKey)    : "↑",
                KEYSTR(NSDownArrowFunctionKey)  : "↓",
                KEYSTR(NSLeftArrowFunctionKey)  : "←",
                KEYSTR(NSRightArrowFunctionKey) : "→",
                
                KEYSTR(NSF1FunctionKey) : "[F1]",
                KEYSTR(NSF2FunctionKey) : "[F2]",
                KEYSTR(NSF3FunctionKey) : "[F3]",
                KEYSTR(NSF4FunctionKey) : "[F4]",
                KEYSTR(NSF5FunctionKey) : "[F5]",
                KEYSTR(NSF6FunctionKey) : "[F6]",
                KEYSTR(NSF7FunctionKey) : "[F7]",
                KEYSTR(NSF8FunctionKey) : "[F8]",
                KEYSTR(NSF9FunctionKey) : "[F9]",
                KEYSTR(NSF10FunctionKey) : "[F10]",
                KEYSTR(NSF11FunctionKey) : "[F11]",
                KEYSTR(NSF12FunctionKey) : "[F12]",
                KEYSTR(NSF13FunctionKey) : "[F13]",
                KEYSTR(NSF14FunctionKey) : "[F14]",
                KEYSTR(NSF15FunctionKey) : "[F15]",
                KEYSTR(NSF16FunctionKey) : "[F16]",
                KEYSTR(NSF17FunctionKey) : "[F17]",
                KEYSTR(NSF18FunctionKey) : "[F18]",
                KEYSTR(NSF19FunctionKey) : "[F19]",
                KEYSTR(NSF20FunctionKey) : "[F20]",
                KEYSTR(NSF21FunctionKey) : "[F21]",
                KEYSTR(NSF22FunctionKey) : "[F22]",
                KEYSTR(NSF23FunctionKey) : "[F23]",
                KEYSTR(NSF24FunctionKey) : "[F24]",
                KEYSTR(NSF25FunctionKey) : "[F25]",
                KEYSTR(NSF26FunctionKey) : "[F26]",
                KEYSTR(NSF27FunctionKey) : "[F27]",
                KEYSTR(NSF28FunctionKey) : "[F28]",
                KEYSTR(NSF29FunctionKey) : "[F29]",
                KEYSTR(NSF30FunctionKey) : "[F30]",
                KEYSTR(NSF31FunctionKey) : "[F31]",
                KEYSTR(NSF32FunctionKey) : "[F32]",
                KEYSTR(NSF33FunctionKey) : "[F33]",
                KEYSTR(NSF34FunctionKey) : "[F34]",
                KEYSTR(NSF35FunctionKey) : "[F35]",
                
                KEYSTR(NSInsertFunctionKey)   : "⎀",
                KEYSTR(NSDeleteFunctionKey)   : "⌦",
                KEYSTR(NSHomeFunctionKey)     : "↖",
                KEYSTR(NSBeginFunctionKey)    : "↸",
                KEYSTR(NSEndFunctionKey)      : "↘",
                KEYSTR(NSPageUpFunctionKey)   : "⇞",
                KEYSTR(NSPageDownFunctionKey) : "⇟",
                
                KEYSTR(NSPrintScreenFunctionKey)  : "NSPrintScreenFunctionKey",
                KEYSTR(NSScrollLockFunctionKey)   : "NSScrollLockFunctionKey",
                KEYSTR(NSPauseFunctionKey)        : "NSPauseFunctionKey",
                KEYSTR(NSSysReqFunctionKey)       : "NSSysReqFunctionKey",
                KEYSTR(NSBreakFunctionKey)        : "NSBreakFunctionKey",
                KEYSTR(NSResetFunctionKey)        : "NSResetFunctionKey",
                KEYSTR(NSStopFunctionKey)         : "NSStopFunctionKey",
                KEYSTR(NSMenuFunctionKey)         : "NSMenuFunctionKey",
                KEYSTR(NSUserFunctionKey)         : "NSUserFunctionKey",
                KEYSTR(NSSystemFunctionKey)       : "NSSystemFunctionKey",
                KEYSTR(NSPrintFunctionKey)        : "⎙",
                KEYSTR(NSClearLineFunctionKey)    : "⌧[NSClearLineFunctionKey]",
                KEYSTR(NSClearDisplayFunctionKey) : "⎚",
                KEYSTR(NSInsertLineFunctionKey)   : "NSInsertLineFunctionKey",
                KEYSTR(NSDeleteLineFunctionKey)   : "NSDeleteLineFunctionKey",
                KEYSTR(NSInsertCharFunctionKey)   : "NSInsertCharFunctionKey",
                KEYSTR(NSDeleteCharFunctionKey)   : "DeleteChar",
                KEYSTR(NSPrevFunctionKey)         : "NSPrevFunctionKey",
                KEYSTR(NSNextFunctionKey)         : "NSNextFunctionKey",
                KEYSTR(NSSelectFunctionKey)       : "NSSelectFunctionKey",
                KEYSTR(NSExecuteFunctionKey)      : "NSExecuteFunctionKey",
                KEYSTR(NSUndoFunctionKey)         : "NSUndoFunctionKey",
                KEYSTR(NSRedoFunctionKey)         : "NSRedoFunctionKey",
                KEYSTR(NSFindFunctionKey)         : "NSFindFunctionKey",
                KEYSTR(NSHelpFunctionKey)         : "[Help]",
                KEYSTR(NSModeSwitchFunctionKey)   : "NSModeSwitchFunctionKey"
            ]
                       
            if let theReadble = theTable[ String(theFirst) ]
            {
                return theReadble
            }
            
            return String(theFirst)
        }
        else
        {
            return ""
        }
    }
    
}
