//
//  Document.h
//  TestTextEdit
//
//  Created by narita on 2016/01/01.
//  Copyright © 2016年 narita. All rights reserved.
//

#import <Cocoa/Cocoa.h>

// イベント
typedef enum SwyftEvent
{
    SE_OTHER,
    SE_LF_UP,
    SE_LF_DOWN,
    SE_LB_UP,
    SE_LB_DOWN,
    SE_TAB_UP,
    SE_TAB_DOWN,
} SwyftEvent;

// 状態
typedef enum SwyftState
{
    ST_NORMAL,
    ST_FIND_F,
    ST_FIND_B,
    ST_SELECT_M,
} SwyftState;

@interface Document : NSDocument


#pragma mark -
#pragma mark action & canAction methods

- (IBAction) updateTextEdit:(nullable id)sender;
- (IBAction) findNext:(nullable id)sender;
- (IBAction) findPrev:(nullable id)sender;
- (IBAction) showFindBar:(nullable id)sender;
- (IBAction) hideFindBar:(nullable id)sender;

#pragma mark -
#pragma mark delegate/datasource methods

#pragma mark -
#pragma mark accessor methods (in pairs)

@property (nullable) IBOutlet NSTextView* textView;
@property (nullable) IBOutlet NSTextField* textField;
@property (nullable) IBOutlet NSSplitView* splitView;

@property (readwrite) SwyftState state;

// 現在注目中の位置
@property (assign) NSRange currentRange;

// leapする前の注目点
@property (assign) NSRange oldRange;

// selectMarkした場合はYES
@property BOOL isSelectMark;

// テキスト
@property (nullable, strong) NSString* textData;

#pragma mark -
#pragma mark Utility methods

// ローマ字入力から正規表現へ変換する。多分migemo関数に相当するはず
- (nullable NSRegularExpression*) romaziToRegularExpression:(nullable NSString*)inRomazi;

@end