//
//  Document.m
//  TestTextEdit
//
//  Created by narita on 2016/01/01.
//  Copyright © 2016年 narita. All rights reserved.
//

#import "Document.h"
#import "AppDelegate.h"

#import "NSString+Migemo.h"
#import "OCMigemo.h"

@interface Document ()
@property (nullable, readwrite) OCMigemo* migemo;
@property (strong, readwrite) id eventMonitor;
@property (strong, readwrite) NSString* lastFindString;
@end

@implementation Document

- (instancetype)init {
    self = [super init];
    if (self) {
        // Add your subclass-specific initialization here.
        
        self.migemo = [OCMigemo new];
    }
    
    return self;
}

- (void)windowControllerDidLoadNib:(NSWindowController *)aController
{
    [super windowControllerDidLoadNib:aController];

    self.textView.string = self.textData;
    [self hideFindBar:nil];

    // フォントを大きくしたい
    
    
    
    
    __weak Document* theWeakSelf = self;

    self.eventMonitor = [NSEvent addLocalMonitorForEventsMatchingMask:( NSKeyUpMask | NSKeyDownMask )
                                                              handler:^(NSEvent* inIncomingEvent)
                         {
                             AppDelegate* theAppDelegate = [NSApp delegate];

                             NSEvent*       theResult    = inIncomingEvent;
                             NSEventType    theEventType = [inIncomingEvent type];
                             unsigned short theKeyCode   = [inIncomingEvent keyCode];
                             SwyftEvent     theEvent     = SE_OTHER;
                             
                             switch (theKeyCode)
                             {
                                 case 48: // タブキー
                                 {
                                     if ( theEventType == NSKeyDown  )
                                     {
                                         theEvent = SE_TAB_DOWN;
                                         [theAppDelegate tabKeyDown:nil];
                                     }
                                     else if(theEventType == NSKeyUp)
                                     {
                                         theEvent = SE_TAB_UP;
                                         [theAppDelegate tabKeyUp:nil];
                                     }
                                 }
                                     break;
                                     
                                 case 102:// 英数キー -> leap right <-- この数字は104かも
                                 {
                                     if ( theEventType == NSKeyDown  )
                                     {
                                         theEvent = SE_LF_DOWN;
                                         [theAppDelegate leapFKeyDown:nil];
                                     }
                                     else if(theEventType == NSKeyUp)
                                     {
                                         theEvent = SE_LF_UP;
                                         [theAppDelegate leapFKeyUp:nil];
                                     }
                                 }
                                     break;
                                     
                                 case 104:// カナキー -> leap left　<-- この数字は102かも
                                 {
                                     if ( theEventType == NSKeyDown  )
                                     {
                                         theEvent = SE_LB_DOWN;
                                         [theAppDelegate leapBKeyDown:nil];
                                     }
                                     else if(theEventType == NSKeyUp)
                                     {
                                         theEvent = SE_LB_UP;
                                         [theAppDelegate leapBKeyUp:nil];
                                     }
                                 }
                                     break;
                                     
                                 default:
                                     break;
                             }
                             
                             switch ( theWeakSelf.state )
                             {
                                 case ST_NORMAL:
                                     theResult = [theWeakSelf otherState:inIncomingEvent event:theEvent];
                                     break;

                                 case ST_FIND_F:
                                     theResult = [theWeakSelf findFState:inIncomingEvent event:theEvent];
                                     break;

                                 case ST_FIND_B:
                                     theResult = [theWeakSelf findBState:inIncomingEvent event:theEvent];
                                     break;

                                 case ST_SELECT_M:
                                     theResult = [theWeakSelf selectMState:inIncomingEvent event:theEvent];
                                     break;

                                 default:
                                     break;
                             }
                             
                             return theResult;
                         }];
    
}

- (NSEvent*) otherState:(NSEvent*)inEvent event:(SwyftEvent)inSEvent
{
    switch(inSEvent)
    {
        case SE_OTHER:   {
            self.state = ST_NORMAL;
            [self cancelOperation:nil];
        }break;
            
        case SE_LF_DOWN: {
            [self storeOldRange:nil];
            [self setMark:nil];
            [self showFindBar:nil];
            self.state = ST_FIND_F;
            inEvent = nil;
        }break;

        case SE_LF_UP:   {
            self.state = ST_NORMAL;
            inEvent = nil;
        }break;
            
        case SE_LB_DOWN: {
            [self storeOldRange:nil];
            [self setMark:nil];
            [self showFindBar:nil];
            self.state = ST_FIND_B;
            inEvent = nil;
        }break;

        case SE_LB_UP:   {
            self.state = ST_NORMAL;
            inEvent = nil;
        }break;
            
        case SE_TAB_DOWN:{
            self.state = ST_NORMAL;
        }break;
            
        case SE_TAB_UP:  {
            self.state = ST_NORMAL;
        }break;
    }
    
    return inEvent;
}

- (NSEvent*) findFState:(NSEvent*)inEvent  event:(SwyftEvent)inSEvent
{
    switch(inSEvent)
    {
        case SE_OTHER:   {
            self.state = ST_FIND_F;
            [self updateTextEdit:nil];
        }break;
            
        case SE_LF_DOWN: {
            self.state = ST_FIND_F;
            inEvent = nil;
        }break;
            
        case SE_LF_UP:   {
            if( self.isSelectMark == YES )
            {
                self.isSelectMark = NO;
            }
            else
            {
                if( self.textField.stringValue.length == 0 )
                {
                    [self.textView moveForward:nil];
                }
                else
                {
                    [self selecteCurrentRange:nil];
                }
            }
            [self hideFindBar:nil];
            [self clearTextFiled:nil];
            self.state = ST_NORMAL;
            inEvent = nil;
        }break;
            
        case SE_LB_DOWN: {
            [self selectToMark:nil];
            self.state = ST_SELECT_M;
            inEvent = nil;
        }break;
            
        case SE_LB_UP:   {
            self.state = ST_FIND_F;
            inEvent = nil;
        }break;
            
        case SE_TAB_DOWN:{
            if( self.textField.stringValue.length == 0)
            {
                self.textField.stringValue = self.lastFindString;
                [self updateTextEdit:nil];
            }
            [self findNext:nil];
            self.state = ST_FIND_F;
            inEvent = nil;
        }break;
            
        case SE_TAB_UP:  {
            self.state = ST_FIND_F;
            inEvent = nil;
        }break;
    }

    return inEvent;
}

- (NSEvent*) findBState:(NSEvent*)inEvent  event:(SwyftEvent)inSEvent
{
    switch(inSEvent)
    {
        case SE_OTHER:   {
            self.state = ST_FIND_B;
            [self updateTextEdit:nil];
        }break;
            
        case SE_LF_DOWN: {
            [self selectToMark:nil];
            self.state = ST_SELECT_M;
            inEvent = nil;
        }break;
            
        case SE_LF_UP:   {
            self.state = ST_FIND_B;
            inEvent = nil;
        }break;
            
        case SE_LB_DOWN: {
            self.state = ST_FIND_B;
            inEvent = nil;
        }break;
            
        case SE_LB_UP:   {
            if( self.isSelectMark == YES)
            {
                self.isSelectMark = NO;
            } else
            {
                if( self.textField.stringValue.length == 0 )
                {
                    [self.textView moveBackward:nil];
                }
                else
                {
                    [self selecteCurrentRange:nil];
                }
            }
            [self hideFindBar:nil];
            [self clearTextFiled:nil];

            self.state = ST_NORMAL;
            inEvent = nil;
        }break;
            
        case SE_TAB_DOWN:{
            if( self.textField.stringValue.length == 0)
            {
                self.textField.stringValue = self.lastFindString;
                [self updateTextEdit:nil];
            }
            [self findPrev:nil];
            self.state = ST_FIND_B;
            inEvent = nil;
        }break;
            
        case SE_TAB_UP:  {
            self.state = ST_FIND_B;
            inEvent = nil;
        }break;
    }

    return inEvent;
}

- (NSEvent*) selectMState:(NSEvent*)inEvent  event:(SwyftEvent)inSEvent
{
    switch(inSEvent)
    {
        case SE_OTHER:   {
            self.state = ST_SELECT_M;
            inEvent = nil;
        }break;
            
        case SE_LF_DOWN: {
            self.state = ST_SELECT_M;
            inEvent = nil;
        }break;
            
        case SE_LF_UP:   {
            self.state = ST_FIND_B;
            inEvent = nil;
        }break;
            
        case SE_LB_DOWN: {
            self.state = ST_SELECT_M;
            inEvent = nil;
        }break;
            
        case SE_LB_UP:   {
            self.state = ST_FIND_F;
            inEvent = nil;
        }break;
            
        case SE_TAB_DOWN:{
            self.state = ST_SELECT_M;
            inEvent = nil;
        }break;
            
        case SE_TAB_UP:  {
            self.state = ST_SELECT_M;
            inEvent = nil;
        }break;
    }
    return inEvent;
}



+ (BOOL)autosavesInPlace {
    return NO;
}

- (NSString *)windowNibName {
    // Override returning the nib file name of the document
    // If you need to use a subclass of NSWindowController or if your document supports multiple NSWindowControllers, you should remove this method and override -makeWindowControllers instead.
    return @"Document";
}

- (NSData *)dataOfType:(NSString *)typeName error:(NSError **)outError {
    
    return [self.textView.string dataUsingEncoding:NSUTF8StringEncoding];;
}

- (BOOL)readFromData:(NSData *)data ofType:(NSString *)typeName error:(NSError **)outError {

    NSString* theString = nil;
    
    theString = [[NSString alloc] initWithData:data
                                      encoding:NSUTF8StringEncoding];
    
    if( theString )
    {
        self.textData = theString;
    }
    
    return self.textData != nil;
}


#pragma mark -
#pragma mark action & canAction methods

- (void) updateTextEdit:(id)sender
{
    NSRegularExpression* theRep;
    
    // ローマ字入力から正規表現へ変換する。
    theRep = [self romaziToRegularExpression:self.textField.stringValue];
    
    
    // TextViewのコンテンツで上記の正規表現オブジェクトの一致する範囲を全てリストアップする
    NSArray* theSelectedRanges;
    
    theSelectedRanges = [[theRep matchesInString:self.textView.string
                                         options:0
                                           range:NSMakeRange(0,
                                                             self.textView.string.length)]
                         valueForKey:@"range"];
    
    
    // 必要ならば注目している場所(黄色いピョン)の位置の修正
    if( [theSelectedRanges containsObject:[NSValue valueWithRange:self.currentRange]] == NO)
    {
        // 最初の選択範囲を選ぶ
        if(theSelectedRanges.count)
        {
            // ToDo:///!!!!!!!!
            // 現在のcurrentRangeから最も近い場所を選ぶ。self.stateで方向を決める。
            
            
            if( self.state == ST_FIND_F)
            {
                // 現在位置よりも大きい、最小の検索結果を選択する。
                NSRange theLastRange = self.oldRange;
                
                for(NSValue* i in theSelectedRanges)
                {
                    NSRange theRange = [i rangeValue];
                    
                    if(self.currentRange.location <= theRange.location)
                    {
                        theLastRange = theRange;
                        break;
                    }
                }
                
                self.currentRange = theLastRange;
            }
            else if ( self.state == ST_FIND_B )
            {
                // 現在位置よりも小さい、最大の検索結果を選択する。
                
                NSRange theLastRange = self.oldRange;
                
                for(NSValue* i in [theSelectedRanges reverseObjectEnumerator])
                {
                    NSRange theRange = [i rangeValue];
                    
                    if(self.currentRange.location >= theRange.location)
                    {
                        theLastRange = theRange;
                        break;
                    }
                }
                
                self.currentRange = theLastRange;
            }
            else
            {
                // エラー
                NSLog(@"xxxx!!!");
            }
        }
        else
        {
            // 存在しないならば、検索前の位置を使用する。
            self.currentRange = self.oldRange;
        }
    }
    
    // 選択範囲群の再設定
    if(theSelectedRanges.count)
    {
        [self.textView setSelectedRanges:theSelectedRanges];
    }
    else
    {
        [self.textView setSelectedRange:self.oldRange];
    }
    
    // スクロールしてぴょん
    [self scrollToVisibleAfterShowAfterIndicatorForCurrentRange:self];
}

- (IBAction) findNext:(id)sender
{
    if( self.currentRange.length != 0 )
    {
        NSInteger theIndex;
        
        theIndex = [self.textView.selectedRanges indexOfObject:[NSValue valueWithRange:self.currentRange]];
        theIndex ++;
        
        if( theIndex >= self.textView.selectedRanges.count)// 最後までいったら最初に戻す
        {
            theIndex = 0;
        }
        
        self.currentRange = [[self.textView.selectedRanges objectAtIndex:theIndex] rangeValue];
        
        // スクロールしてぴょん
        [self scrollToVisibleAfterShowAfterIndicatorForCurrentRange:self];
    }
}

- (IBAction) findPrev:(id)sender
{
    if( self.currentRange.length != 0 )
    {
        NSInteger theIndex;
        
        theIndex = [self.textView.selectedRanges indexOfObject:[NSValue valueWithRange:self.currentRange]];
        theIndex --;
        
        if( theIndex < 0)// 最初までいったら最後に戻す
        {
            theIndex = self.textView.selectedRanges.count - 1;
        }
        
        self.currentRange = [[self.textView.selectedRanges objectAtIndex:theIndex] rangeValue];
        
        // スクロールしてぴょん
        [self scrollToVisibleAfterShowAfterIndicatorForCurrentRange:self];
    }
}

// 次のイベントループでshowFindIndicatorForRangeを呼出さないと、"ぴょん"が表示されないときが有るので
// すこし遅らせてから黄色いピョンを実行する
- (IBAction) scrollToVisibleAfterShowAfterIndicatorForCurrentRange:(id)sender
{
    [self.textView scrollRangeToVisible:self.currentRange];
    
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, 0.0 * NSEC_PER_SEC),
                   dispatch_get_main_queue(),
                   ^(void)
                   {
                       [self.textView showFindIndicatorForRange:self.currentRange];
                   });
}

- (IBAction) storeOldRange:(id)sender
{
    self.oldRange = self.textView.selectedRange;
}

- (IBAction) selecteCurrentRange:(nullable id)sender
{
    [self.textView setSelectedRange:self.currentRange];
}

- (IBAction) showFindBar:(nullable id)sender
{
    [self.textField setHidden:NO];
    [self.splitView adjustSubviews];
    
    [self.textField.window makeFirstResponder:self.textField];
}

- (IBAction) hideFindBar:(nullable id)sender
{
    [self.textField setHidden:YES];
    [self.splitView adjustSubviews];
    
    [self.textView.window makeFirstResponder:self.textView];
}

- (BOOL)splitView:(NSSplitView *)splitView canCollapseSubview:(NSView *)subview
{
    if( self.textField == subview )
    {
        return YES;
    }
    
    return NO;
}

// LEAPの操作によってマークする位置が随時変更される
- (IBAction) setMark:(nullable id)sender
{
    [self.textView setMark:sender];
}

- (IBAction) deleteToMark:(nullable id)sender
{
    [self.textView deleteToMark:sender];
}

- (IBAction) clearTextFiled:(nullable id)sender
{
    self.lastFindString = self.textField.stringValue;
    self.textField.stringValue = @"";
}

- (IBAction) cancelOperation:(id)sender
{
//    [self.textView cancelOperation:sender];
}

// これが両方のLEAPキーを同時押ししたのと同じ
- (IBAction) selectToMark:(nullable id)sender
{
    [self.textView setSelectedRange:self.currentRange];
    [self.textView selectToMark:sender];
    
    self.isSelectMark = YES;
}

//- (IBAction) swapWithMark:(nullable id)sender
//{
//    [self.textView swapWithMark:sender];
//}


#pragma mark -
#pragma mark delegate/datasource methods

- (void)controlTextDidChange:(NSNotification *)obj
{
    // テキストが変更されたら再計算
    if( self.textField == [obj object])
    {
        [self updateTextEdit:self];
    }
}

#pragma mark -
#pragma mark accessor methods (in pairs)

#pragma mark -
#pragma mark Utility methods

- (NSRegularExpression*) romaziToRegularExpression:(NSString*)inRomazi
{
    NSError* theErr = NULL;

    NSString* patern = [self.migemo paternWithString:inRomazi];
    
    return [NSRegularExpression regularExpressionWithPattern:patern
                                                     options:0
                                                       error:&theErr];
}

@end
