//
//  SKTInspectorPaletteController.m
//  Sketch
//
//  Created by narita on 2014/09/21.
//
//

#import "SKTInspectorPaletteController.h"
#import "SKTDocument.h"
#import "MAKVONotificationCenter.h"

@interface SKTInspectorPaletteController ()

+ (void)addInspectorPaletteWindowController:(SKTInspectorPaletteController *)windowController;
+ (void)removeInspectorPaletteWindowController:(SKTInspectorPaletteController *)windowController;

@property (readwrite, strong) NSArrayController* graphicsController;// インスペクト対象物へのArrayController
@property (readwrite, assign) SKTDocument*       graphicsDocument;  // 固定インスペクト型の時のインスペクト対象Document
@property (readwrite, strong) NSArray*           selectedGraphics;  // 固定インスペクト型の時のインスペクト対象Object群
@end

@implementation SKTInspectorPaletteController

#pragma mark -
#pragma mark class methods

static NSMutableArray* sWindowArray;

+ (void)addInspectorPaletteWindowController:(SKTInspectorPaletteController *)windowController
{
    if( sWindowArray == nil )
    {
        sWindowArray = [[NSMutableArray alloc] init];
    }
    
    [sWindowArray addObject:windowController];
}

+ (void)removeInspectorPaletteWindowController:(SKTInspectorPaletteController *)windowController
{
    [sWindowArray removeObject:windowController];
}

#pragma mark -
#pragma mark init methods

- (id)init
{
    self = [self initWithWindowNibName:@"Inspector"];
    
    if (self)
    {
        [SKTInspectorPaletteController addInspectorPaletteWindowController:self];
    }
    
    return self;
}

#pragma mark -
#pragma mark dealloc


#pragma mark -
#pragma mark NSCopying, hash, isEqual:

#pragma mark -
#pragma mark NSCoding methods

#pragma mark -
#pragma mark awakeFromNib-like methods

- (void)windowDidLoad
{
    [super windowDidLoad];
    
    [(NSPanel *)[self window] setBecomesKeyOnlyIfNeeded:YES];
    
    // インスペクト開始
    if( self.isPinned )
    {
        [self startFixedType];
    }
    else
    {
        [self startFloatingType];
    }
}

#pragma mark -
#pragma mark action & canAction methods

- (IBAction) pinnedAction:(id)sender
{
    if( self.isPinned )
    {
        [self stopFloatingType];
        [self startFixedType];
    }
    else
    {
        [self stopFixedType];
        [self startFloatingType];
    }
}

#pragma mark -
#pragma mark delegate/datasource methods

- (void)windowWillClose:(NSNotification *)notification;
{
    // インスペクト停止
    if( self.isPinned )
    {
        [self stopFixedType];
    }
    else
    {
        [self stopFloatingType];
    }
    
    [SKTInspectorPaletteController removeInspectorPaletteWindowController:self];
}

#pragma mark -
#pragma mark accessor methods (in pairs)

#pragma mark -
#pragma mark Utility methods

// 変動インスペクタ型　(floating type)
- (void) startFloatingType
{
    // メインウインドウをインスペクト対象にする
    self.graphicsController = [[NSApp mainWindow] valueForKeyPath:@"windowController.graphicsController"];
    
    // メインウインドウが変われば選択箇所も変わる。インスペクトする場所も変わるように変更追跡を開始する。
    [NSApp addObserver:self
            forKeyPath:@"mainWindow"
              selector:@selector(updateFloatingType)
              userInfo:nil
               options:0];
}

- (void) stopFloatingType
{
    // メインウインドウの変更追跡を停止する
    [NSApp removeObserver:self
                  keyPath:@"mainWindow"
                 selector:@selector(updateFloatingType)];
    
    self.graphicsDocument   = nil;
    self.graphicsController = nil;
}

- (void) updateFloatingType
{
    // 追跡対象に変更が有ったので、インスペクトする場所を再設定する
    self.graphicsController = [[NSApp mainWindow] valueForKeyPath:@"windowController.graphicsController"];
}

#pragma mark -

// 固定インスペクタ型 (fixed type)

- (void) startFixedType
{
    // 対象とするdocumentの保存
    self.graphicsDocument = [[NSApp mainWindow] valueForKeyPath:@"windowController.document"];

    // 対象とするgraphics(NSArray)のコピーを保存(スナップショット)
    self.selectedGraphics = [[[NSApp mainWindow] valueForKeyPath:@"windowController.graphicsController.selectedObjects"] copy];
    self.graphicsController = [[NSArrayController alloc ] initWithContent:self.selectedGraphics];
    [self.graphicsController setSelectedObjects:self.selectedGraphics];
    
    
    // Document削除の検知を開始
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(updateFixedTypeForDocumentWillDealloc)
                                                 name:SKTDocumentWillDeallocNotification
                                               object:self.graphicsDocument];
    
    
    // 画像の増減の検知を開始
    [self.graphicsDocument addObserver:self
                            forKeyPath:@"graphics"
                              selector:@selector(updateFixedTypeForGraphics)
                              userInfo:nil
                               options:0];
    
}

- (void) stopFixedType
{
    // Document削除の検知を停止
    [[NSNotificationCenter defaultCenter] removeObserver:self
                                                    name:SKTDocumentWillDeallocNotification
                                                  object:self.graphicsDocument];
    
    // 画像の増減の検知を停止
    [self.graphicsDocument removeObserver:self
                                  keyPath:@"graphics"
                                 selector:@selector(updateFixedTypeForGraphics)];
    
    
    
    self.graphicsDocument   = nil;
    self.graphicsController = nil;
    self.selectedGraphics   = nil;
}

// 追跡中のgraphicsDocumentのgraphicsが変更された(増減が有った)
- (void) updateFixedTypeForGraphics
{
    // Undo/Redo対策に、ドキュメントが直接保持しているグラフィックオブジェクトだけを対象にする。
    // 何も考えないと、undo/redoスタックに入ったオブジェクトもインスペクタから編集できてしまう。
    // 保管されたスナップショット  :  self.selectedGraphics
    // ドキュメントの中のgraphics : self.graphicsDocument.graphics
    // 上記2つの&をとって、その値をコントローラーに設定する。
    // しかし、配列の順列を順列を維持するために以下のようになる。
    
    NSMutableSet* theSelectedGraphicsSet = [NSMutableSet setWithArray:self.selectedGraphics];
    NSSet*        theDocumentGraphicsSet = [NSSet setWithArray:[self.graphicsDocument valueForKey:@"graphics"]];
    
    [theSelectedGraphicsSet minusSet:theDocumentGraphicsSet];
    
    NSMutableArray* theSelectedGraphics = [NSMutableArray arrayWithArray:self.selectedGraphics];
    [theSelectedGraphics removeObjectsInArray:[theSelectedGraphicsSet allObjects]];
    
    self.graphicsController = [[NSArrayController alloc ] initWithContent:theSelectedGraphics];
    [self.graphicsController setSelectedObjects:theSelectedGraphics];
}

// 追跡中のドキュメントが放棄された
- (void) updateFixedTypeForDocumentWillDealloc
{
    self.isPinned = NO;
    [self pinnedAction:self];
}


@end
