//
//  TPToolPaletteWindowController.m
//  ToolPalette
//
//  Created by narita on 2014/09/20.
//  Copyright (c) 2014年 narita. All rights reserved.
//

#import "SKTToolPaletteController.h"

@interface SKTToolPaletteController ()

+ (void)addToolPaletteWindowController:(SKTToolPaletteController *)windowController;
+ (void)removeToolPaletteWindowController:(SKTToolPaletteController *)windowController;

@end

@implementation SKTToolPaletteController

#pragma mark -
#pragma mark class methods

static NSMutableArray* sWindowArray;

+ (void)addToolPaletteWindowController:(SKTToolPaletteController *)windowController
{
    if( sWindowArray == nil )
    {
        sWindowArray = [[NSMutableArray alloc] init];
    }
    
    [sWindowArray addObject:windowController];
}

+ (void)removeToolPaletteWindowController:(SKTToolPaletteController *)windowController
{
    [sWindowArray removeObject:windowController];
}

#pragma mark -
#pragma mark init methods

- (id)init
{    
    self = [self initWithWindowNibName:@"SKTToolPaletteController"];

    if (self)
    {
        [SKTToolPaletteController addToolPaletteWindowController:self];
    }
    
    return self;
}

#pragma mark -
#pragma mark dealloc

#pragma mark -
#pragma mark NSCopying, hash, isEqual:

#pragma mark -
#pragma mark NSCoding methods

#pragma mark -
#pragma mark awakeFromNib-like methods

- (void)windowDidLoad
{
    [super windowDidLoad];
    
    [(NSPanel *)[self window] setBecomesKeyOnlyIfNeeded:YES];
}

#pragma mark -
#pragma mark action & canAction methods

- (void)windowWillClose:(NSNotification *)notification;
{
    [SKTToolPaletteController removeToolPaletteWindowController:self];
}

#pragma mark -
#pragma mark delegate/datasource methods

#pragma mark -
#pragma mark accessor methods (in pairs)

#pragma mark -
#pragma mark Utility methods

@end
