//
//  SKTToolSelectModel.m
//  Sketch
//
//  Created by narita on 2014/09/20.
//
//

#import "SKTToolSelectModel.h"

enum {
    SKTArrowToolRow = 0,
    SKTRectToolRow,
    SKTCircleToolRow,
    SKTLineToolRow,
    SKTTextToolRow,
};

NSString *SKTSelectedToolDidChangeNotification = @"SKTSelectedToolDidChange";

@implementation SKTToolSelectModel

#pragma mark -
#pragma mark class methods

+ (NSSet*) keyPathsForValuesAffectingCurrentGraphicClass
{
    return [NSSet setWithObjects:@"currentToolNumber", nil];
}

#pragma mark -
#pragma mark init methods

#pragma mark -
#pragma mark dealloc

#pragma mark -
#pragma mark NSCopying, hash, isEqual:

#pragma mark -
#pragma mark NSCoding methods

#pragma mark -
#pragma mark awakeFromNib-like methods

#pragma mark -
#pragma mark action & canAction methods

- (IBAction)selectArrowTool:(id)sender
{
    self.currentToolNumber = SKTArrowToolRow;
}

#pragma mark -
#pragma mark delegate/datasource methods

#pragma mark -
#pragma mark accessor methods (in pairs)

@synthesize currentToolNumber;

- (void) setCurrentToolNumber:(NSInteger) inCurrentToolNumber
{
    @synchronized(self)
    {
        if( currentToolNumber != inCurrentToolNumber )
        {
            [self willChangeValueForKey:@"currentToolNumber"];
            
            currentToolNumber = inCurrentToolNumber;
            
            [self didChangeValueForKey:@"currentToolNumber"];
            
            [[NSNotificationCenter defaultCenter] postNotificationName:SKTSelectedToolDidChangeNotification
                                                                object:self];
        }
    }
}

- (Class) currentGraphicClass
{
    Class theClass = nil;
    
    @synchronized(self)
    {
        switch (self.currentToolNumber)
        {
            case SKTArrowToolRow:
                theClass = nil;
                break;
                
            case SKTRectToolRow:
                theClass = NSClassFromString(@"SKTRectangle");
                break;
                
            case SKTCircleToolRow:
                theClass = NSClassFromString(@"SKTCircle");
                break;
                
            case SKTLineToolRow:
                theClass = NSClassFromString(@"SKTLine");
                break;
                
            case SKTTextToolRow:
                theClass = NSClassFromString(@"SKTText");
                break;
                
            default:
                break;
        }
    }
    
    return theClass;
}

#pragma mark -
#pragma mark Utility methods

@end
